<?php
/**
 * WooCommerce Default template.
 *
 * @package TotalTheme
 * @subpackage Templates
 * @version 5.5
 */

defined( 'ABSPATH' ) || exit;

get_header();

?>

<div id="content-wrap" class="container wpex-clr">

	<?php wpex_hook_primary_before(); ?>

	<div id="primary" class="content-area wpex-clr">

		<?php wpex_hook_content_before(); ?>

		<div id="content" class="site-content wpex-clr">

			<?php wpex_hook_content_top(); ?>

			<article class="entry-content entry wpex-clr"><?php

				// Single Products
				if ( is_singular() ) {
					if ( ! wpex_theme_do_location( 'single' ) ) {
						woocommerce_content();
					}
				}
				// Product archives.
				else {

					// Custom shop output.
					if ( wpex_has_woo_mods() && ! wpex_woo_archive_has_loop() ) {
						$shop_page = get_post( wc_get_page_id( 'shop' ) );
						if ( $shop_page && $shop_page->post_content ) {
							echo wpex_the_content( $shop_page->post_content );
						}
					}

					// Default shop output.
					elseif ( ! wpex_theme_do_location( 'archive' ) ) {
						woocommerce_content();
					}

				}

			?></article>

			<?php wpex_hook_content_bottom(); ?>

		</div>

		<?php wpex_hook_content_after(); ?>

	</div>

	<?php wpex_hook_primary_after(); ?>

</div>

<?php get_footer(); ?>