<?php
use TotalTheme\Topbar\Core as Topbar;
use TotalTheme\Integration\WPBakery\Shortcode_Inline_Style as WPB_Style;

/**
 * Topbar content.
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.4.6
 */

defined( 'ABSPATH' ) || exit;

$content = Topbar::get_content();

if ( $content || has_nav_menu( 'topbar_menu' ) ) : ?>

	<div id="top-bar-content" <?php Topbar::content_class(); ?>><?php

		// Get topbar menu.
		get_template_part( 'partials/topbar/topbar-menu' );

		// Display content.
		if ( $content ) {
			WPB_Style::instance()->render_style( Topbar::get_template_id() );
			echo do_shortcode( wp_kses_post( $content ) );
		}

	?></div>

<?php endif; ?>