<?php
/**
 * Togglebar button output.
 *
 * @package Total WordPress theme
 * @subpackage Partials
 * @version 5.5.2
 */

defined( 'ABSPATH' ) || exit;

$toggle_bar_style = wpex_togglebar_style();
$default_state    = wpex_togglebar_state();
$visibility       = wpex_togglebar_visibility();

// Link attributes.
$attrs = [
	'href'  => '#',
	'id'    => 'toggle-bar-button',
	'class' => [
		'toggle-bar-btn',
		'fade-toggle',
		'open-togglebar',
		'wpex-block',
		'wpex-top-0',
		'wpex-right-0',
		'wpex-text-white',
		'wpex-hover-text-white',
	],
	'aria-hidden' => 'true',
];

// Set correct position.
if ( 'inline' === $toggle_bar_style ) {
	$attrs['class'][] = 'wpex-absolute';
} else {
	$attrs['class'][] = 'wpex-fixed';
}

// Visibility.
if ( $visibility && 'always-visible' !== $visibility ) {
	$attrs['class'][] = $visibility;
}

// Add active class if set to display by default.
if ( 'visible' === $default_state ) {
	$attrs['class'][] = 'active-bar';
}

$attrs['aria-controls'] = 'toggle-bar-wrap';
$attrs['aria-expanded'] = ( 'visible' === $default_state ) ? 'true' : 'false';

$icons_html = '';

// Closed icon classes.
$closed_icon = get_theme_mod( 'toggle_bar_button_icon', 'plus' );

/**
 * Filters the togglebar closed icon class.
 *
 * @param string $class
 */
$closed_icon = apply_filters( 'wpex_togglebar_icon_class', $closed_icon );

if ( $closed_icon ) {
	$icons_html .= '<span class="toggle-bar-btn__icon toggle-bar-btn__icon--closed wpex-flex">';
		$icons_html .= wpex_get_theme_icon_html( $closed_icon );
	$icons_html .= '</span>';
}

// Active icon classes.
$active_icon = get_theme_mod( 'toggle_bar_button_icon_active', 'minus' );

/**
 * Filters the togglebar active icon class.
 *
 * @param string $class
 */
$active_icon = apply_filters( 'wpex_togglebar_icon_active_class', $active_icon );
$active_icon = $active_icon ?: $closed_icon;

if ( $active_icon ) {
	$icons_html .= '<span class="toggle-bar-btn__icon toggle-bar-btn__icon--open wpex-flex">';
		$icons_html .= wpex_get_theme_icon_html( $active_icon );
	$icons_html .= '</span>';
}

// Display button.
echo wpex_parse_html( 'a', $attrs, $icons_html ); ?>