<?php
/**
 * Site header search replace.
 *
 * @package Total WordPress theme
 * @subpackage Partials
 * @version 5.6
 */

use TotalTheme\Header\Menu\Search;

defined( 'ABSPATH' ) || exit;

$class = [
    'header-searchform-wrap',
    'wpex-surface-1',
    'wpex-text-3',
    'wpex-absolute',
    'wpex-z-999',
    'wpex-inset-0',
    'wpex-transition-all',
    'wpex-duration-300',
    'wpex-invisible',
    'wpex-opacity-0',
];

$button_hover_class = '';

if ( ! get_theme_mod( 'header_background' ) ) {
    $button_hover_class = ' wpex-hover-text-1';
}

?>

<div id="searchform-header-replace" class="<?php echo esc_attr( implode( ' ', $class ) ); ?>" data-placeholder="<?php echo esc_attr( Search::get_placeholder_text() ); ?>" data-disable-autocomplete="true">
	<?php echo Search::get_form(); ?>
	<button id="searchform-header-replace-close" class="wpex-unstyled-button wpex-absolute wpex-top-50 wpex-right-0 -wpex-translate-y-50 wpex-transition-colors wpex-user-select-none<?php echo esc_attr( $button_hover_class ); ?>">
        <span class="searchform-header-replace-close__icon" aria-hidden="true">&times;</span>
        <span class="screen-reader-text"><?php esc_html_e( 'Close search', 'total' ); ?></span>
    </button>
</div>