<?php
/**
 * Header Builder Content
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.7.0
 */

defined( 'ABSPATH' ) || exit;

if ( wpex_is_header_builder_page() && ( wpex_vc_is_inline() || wpex_elementor_is_preview_mode() ) ) :

	while ( have_posts() ) : the_post();
		the_content();
	endwhile;

else :

	if ( $id = wpex_header_builder_id() ) {
		if ( 'elementor_library' == get_post_type( $id ) && class_exists( 'Elementor\Frontend' ) ) {
			echo wpex_get_elementor_content_for_display( $id );
		} else {
			$content = get_post_field( 'post_content', $id );
			$content = wpex_sanitize_template_content( $content );
			echo apply_filters( 'wpex_header_builder_content', $content ); // apply filters and return content
		}
	}

endif;