<?php
use TotalTheme\Header\Core as Header;
use TotalTheme\Header\Aside as Header_Aside;
use TotalTheme\Integration\WPBakery\Shortcode_Inline_Style as WPB_Style;

/**
 * Header aside content used in Header Style Two, Three and Four.
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.4.6
 */

defined( 'ABSPATH' ) || exit;

$header_style = Header::style();
$content      = Header_Aside::get_content();

// Display header aside if content exists or it's header style 2 and the main search is enabled.
if ( $content || ( get_theme_mod( 'main_search', true ) && 'two' === $header_style ) ) :

	// Placeholder.
	$placeholder = esc_html__( 'search', 'total' );

	/**
	 * Filters the header aside search field placeholder text.
	 *
	 * @param string $placeholder
	 */
	$placeholder = (string) apply_filters( 'wpex_get_header_aside_search_form_placeholder', $placeholder );

	// Button text
	$button_text = wpex_get_theme_icon_html( 'search' ) . '<span class="screen-reader-text">' . esc_html__( 'Search', 'total' ) . '</span>';

	// Add inline template CSS.
	WPB_Style::instance()->render_style( Header_Aside::get_template_id() );

	?>

	<aside id="header-aside" <?php Header_Aside::wrapper_class(); ?>>
		<div class="header-aside-content wpex-clr"><?php
			echo do_shortcode( wp_kses_post( $content ) );
		?></div>
		<?php
		// Show header search field if enabled in the theme options panel and it's header style 2.
		if ( 'two' === $header_style && get_theme_mod( 'header_aside_search', true ) ) : ?>
			<div id="header-two-search" class="wpex-clr">
				<form method="get" class="header-two-searchform" action="<?php echo esc_url( home_url( '/' ) ); ?>">
					<label>
						<span class="screen-reader-text"><?php echo esc_attr( $placeholder ); ?></span>
						<input type="search" id="header-two-search-input" name="s" placeholder="<?php echo esc_attr( $placeholder ); ?>">
					</label>
					<?php if ( defined( 'ICL_LANGUAGE_CODE' ) ) : ?>
						<input type="hidden" name="lang" value="<?php echo( ICL_LANGUAGE_CODE ); ?>">
					<?php endif; ?>
					<?php if ( WPEX_WOOCOMMERCE_ACTIVE && get_theme_mod( 'woo_header_product_searchform', false ) ) { ?>
						<input type="hidden" name="post_type" value="product">
					<?php } ?>
					<button type="submit" id="header-two-search-submit"><?php echo apply_filters( 'wpex_header_aside_search_button_text', $button_text ); ?></button>
				</form>
			</div>
		<?php endif; ?>
	</aside>

<?php endif;