<?php
use TotalTheme\Footer\Callout as Footer_Callout;

/**
 * Footer callout
 *
 * @package TotalTheme
 * @subpackage Partials
 * @version 5.7.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! Footer_Callout::is_enabled() ) {
	return;
}

$content = Footer_Callout::get_content();
$button  = Footer_Callout::get_button();

if ( ! $content && ! $button ) {
	return;
}

?>

<div id="footer-callout-wrap" <?php Footer_Callout::wrapper_class(); ?><?php wpex_aria_label( 'footer_callout' ); ?><?php wpex_aria_landmark( 'footer_callout' ); ?>>

	<div id="footer-callout" <?php Footer_Callout::inner_class(); ?>>

		<?php if ( $content ) { ?>

			<div id="footer-callout-left" <?php Footer_Callout::content_class(); ?>><?php
				echo do_shortcode( wp_kses_post( $content ) );
			?></div>

			<?php if ( $button ) { ?>

				<div id="footer-callout-right" <?php Footer_Callout::button_class(); ?>><?php

					echo wp_kses_post( $button );

				?></div>

			<?php } ?>

		<?php } elseif ( $button ) { ?>

			<?php echo wp_kses_post( $button ); ?>

		<?php } ?>

	</div>

</div>