<?php
namespace TotalTheme\Walkers;

use Walker_Nav_Menu;

defined( 'ABSPATH' ) || exit;

/**
 * Custom Walker_Nav_Menu for the core menu widget.
 *
 * @package TotalTheme
 * @subpackage Filters
 * @version 5.5
 */
class Widget_Nav_Menu extends Walker_Nav_Menu {
	function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
		$id_field = $this->db_fields['id'];

		// Down Arrows.
		if ( ! empty( $children_elements[$element->$id_field] ) ) {
			$arrow_icon = apply_filters( 'wpex_widget_nav_menu_open_submenu_icon', 'material/arrow-down-ios' );
			$down_arrow = wpex_get_theme_icon_html( $arrow_icon, 'wpex-open-submenu__icon wpex-mr-10' );
			if ( $down_arrow  ) {
				$element->title .= '<button aria-haspopup="true" aria-expanded="false" aria-label="' . esc_attr__( 'Toggle submenu of', 'total' ) . ' ' . trim( esc_attr( strip_shortcodes( $element->title ) ) )  . '" class="wpex-open-submenu wpex-unstyled-button wpex-items-center wpex-justify-end wpex-absolute wpex-top-0 wpex-right-0 wpex-h-100 wpex-w-100 wpex-cursor-pointer wpex-overflow-hidden">' . $down_arrow . '</button>';
			}
		}

		// Define walker.
		Walker_Nav_Menu::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}
}