<?php
namespace TotalTheme;

use TotalTheme\Theme_Builder\Render_Template;
use TotalTheme\Theme_Builder\Location_Template;

defined( 'ABSPATH' ) || exit;

/**
 * Theme Builder.
 *
 * @package TotalTheme
 * @subpackage ThemeBuilder
 * @version 5.7.0
 */
class Theme_Builder {

	/**
	 * Parsed locations.
	 */
	protected static $did_locations = [];

	/**
	 * Location currently being shown.
	 */
	protected static $current_location;

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Main Theme_Builder Instance.
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Theme_Builder ) ) {
			self::$instance = new Theme_Builder;
		}

		return self::$instance;
	}

	/**
	 * Returns template post types.
	 */
	public static function get_template_post_types() {
		$types = [
			'wpex_templates'    => esc_html__( 'Dynamic Templates', 'total' ),
			'templatera'        => 'Templatera',
			'elementor_library' => esc_html__( 'Elementor Library', 'total' ),
		];
		$types = array_filter( $types, 'post_type_exists', ARRAY_FILTER_USE_KEY );
		return (array) apply_filters( 'totaltheme/theme-builder/template_post_types', $types );
	}

	/**
	 * Returns the current location being displayed.
	 */
	public function get_current_location() {
		return self::$current_location;
	}

	/**
	 * Returns the current location being displayed.
	 */
	public function did_location( $location ) {
		return in_array( $location, self::$did_locations, true );
	}

	/**
	 * Checks if a location has a defined template.
	 */
	public function location_has_template( $location ) {
		$location_template = new Location_Template( $location );
		if ( ! empty( $location_template->template ) ) {
			$render_template = new Render_Template( $location_template->template, $location );
			return (bool) $render_template->get_template_content();
		}
	}

	/**
	 * Do location.
	 */
	public function do_location( $location ) {

		// Check for elementor templates first.
		if ( function_exists( 'elementor_theme_do_location' ) ) {
			$elementor_doc = elementor_theme_do_location( $location );
			if ( $elementor_doc ) {
				return true;
			}
		}

		// Check for theme templates.
		$location_template = new Location_Template( $location );

		if ( ! empty( $location_template->template ) ) {
			$render_template = new Render_Template( $location_template->template, $location );
			return $render_template->render();
		}

	}

}