<?php
namespace TotalTheme\Scripts;

use TotalTheme\Header\Overlay as Overlay_Header;
use TotalTheme\Header\Vertical as Vertical_Header;
use TotalTheme\Mobile\Menu as Mobile_Menu;
use TotalTheme\Theme_Icons;

defined( 'ABSPATH' ) || exit;

/**
 * CSS Scripts.
 *
 * @package TotalTheme
 * @subpackage Scripts
 * @version 5.5.3
 */
class CSS {

	/**
	 * Theme handle.
	 */
	protected static $theme_handle;

	/**
	 * Get theme handle.
	 */
	public static function get_theme_handle() {
		if ( ! is_null( self::$theme_handle ) ) {
			return self::$theme_handle;
		}

		$theme_handle = WPEX_THEME_STYLE_HANDLE;

		if ( is_child_theme() ) {

			/**
			 * Filters the theme handle used for the parent theme when enqueing the style.css via
			 * a child theme.
			 *
			 * @param string $theme_handle
			 */
			$parent_handle = (string) apply_filters( 'wpex_parent_stylesheet_handle', 'parent-style' );

			if ( wp_style_is( $parent_handle ) ) {
				$theme_handle = $parent_handle; // only alter the handle if the script is actually loaded.
			}
		}

		self::$theme_handle = $theme_handle;

		return self::$theme_handle;
	}

	/**
	 * Register Theme styles.
	 */
	public static function register() {
		if ( Theme_Icons::is_enabled() ) {
			Theme_Icons::register_font_style();
		}

		wp_register_style(
			'wpex-hover-animations',
			wpex_asset_url( 'lib/hover-css/hover-css.min.css' ),
			[],
			'2.0.1'
		);

		wp_register_style(
			'slider-pro',
			wpex_asset_url( 'lib/slider-pro/jquery.sliderPro.min.css' ),
			[],
			'1.3'
		);
	}

	/**
	 * Enqueue Theme styles.
	 */
	public static function enqueue() {

		// Main style.css File.
		wp_enqueue_style(
			WPEX_THEME_STYLE_HANDLE, // !! must be hardset here !!
			get_stylesheet_uri(),
			[],
			WPEX_THEME_VERSION
		);

		$theme_handle = self::get_theme_handle();

		// Override main style.css with style-rtl.css.
		wp_style_add_data( $theme_handle, 'rtl', 'replace' );

		// Mobile menu breakpoint CSS.
		$mm_breakpoint = Mobile_Menu::breakpoint();
		$max_media     = false;
		$min_media     = false;

		if ( $mm_breakpoint < 9999 && wpex_is_layout_responsive() ) {
			$max_media = 'only screen and (max-width:' . $mm_breakpoint . 'px)';
			$min_media = 'only screen and (min-width:' . ( $mm_breakpoint + 1 )  . 'px)';
		}

		wp_enqueue_style(
			'wpex-mobile-menu-breakpoint-max',
			wpex_asset_url( 'css/wpex-mobile-menu-breakpoint-max.css' ),
			$theme_handle ? array( $theme_handle ) : [],
			WPEX_THEME_VERSION,
			$max_media
		);

		wp_style_add_data( 'wpex-mobile-menu-breakpoint-max', 'rtl', 'replace' );

		if ( $min_media ) {
			wp_enqueue_style(
				'wpex-mobile-menu-breakpoint-min',
				wpex_asset_url( 'css/wpex-mobile-menu-breakpoint-min.css' ),
				$theme_handle ? [ $theme_handle ] : [],
				WPEX_THEME_VERSION,
				$min_media
			);

			wp_style_add_data( 'wpex-mobile-menu-breakpoint-min', 'rtl', 'replace' );

			// Vertical header CSS
			Vertical_Header::maybe_enqueue_stylesheet();
		}

		// Overlay/Transparent header.
		Overlay_Header::maybe_enqueue_stylesheet();

		// WPBakery.
		if ( WPEX_VC_ACTIVE && wpex_has_vc_mods() ) {
			$deps = [ WPEX_THEME_STYLE_HANDLE ];

			if ( wp_style_is( 'js_composer_front', 'registered' ) ) {
				$deps[] = 'js_composer_front';
			}

			wp_enqueue_style(
				'wpex-wpbakery',
				wpex_asset_url( 'css/wpex-wpbakery.css' ),
				$deps,
				WPEX_THEME_VERSION
			);

			wp_style_add_data( 'wpex-wpbakery', 'rtl', 'replace' );
		}

		// Load theme icons.
		if ( Theme_Icons::is_enabled() && 'font' === Theme_Icons::get_format() ) {
			Theme_Icons::enqueue_font_style();
		}

		// Total Shortcodes.
		if ( get_theme_mod( 'extend_visual_composer', true ) ) {
			wp_enqueue_style(
				'vcex-shortcodes',
				wpex_asset_url( 'css/vcex-shortcodes.css' ),
				[],
				WPEX_THEME_VERSION
			);

			wp_style_add_data( 'vcex-shortcodes', 'rtl', 'replace' );
		}

		// Customizer CSS.
		if ( is_customize_preview() ) {
			wp_enqueue_style(
				'wpex-customizer-shortcuts',
				wpex_asset_url( 'css/wpex-customizer-shortcuts.css' ),
				[],
				WPEX_THEME_VERSION
			);
		}
	}

}