<?php
namespace TotalTheme\Integration\Yoast_SEO;

defined( 'ABSPATH' ) || exit;

/**
 * Customizer settings for Yoast.
 *
 * @package TotalTheme
 * @subpackage Integration
 * @version 5.6.1
 */
class Customizer {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'customize_register', [ $this, 'register_settings' ] );
	}

	/**
	 * Customizer Settings.
	 */
	public function register_settings( $wp_customize ) {
		$wp_customize->add_setting( 'enable_yoast_breadcrumbs' , array(
			'default'           => true,
			'transport'         => 'refresh',
			'sanitize_callback' => 'wp_validate_boolean',
		) );

		$wp_customize->add_control( 'enable_yoast_breadcrumbs', array(
			'label'    => __( 'Override Theme Breadcrumbs', 'total' ),
			'section'  => 'wpseo_breadcrumbs_customizer_section',
			'settings' => 'enable_yoast_breadcrumbs',
			'type'     => 'checkbox',
			'priority' => -1,
		) );
	}

}