<?php
namespace TotalTheme\Integration\WPBakery;

defined( 'ABSPATH' ) || exit;

final class Modify_Weights {

	/**
	 * List of shortcodes to modify.
	 */
	protected $shortcodes = [
		'vc_single_image',
		'vc_icon',
		'vc_separator',
		'vc_custom_heading',
		'vc_zigzag',
		'vc_text_separator',
		'vc_message',
		'vc_facebook',
		'vc_tweetmeme',
		'vc_googleplus',
		'vc_pinterest',
		'vc_toggle',
		'vc_btn',
		'vc_cta',
		'vc_flickr', // @todo drop?
		'vc_progress_bar',
		'vc_basic_grid',
		'vc_media_grid',
		'vc_masonry_grid',
		'vc_masonry_media_grid',
		'vc_hoverbox',
	];

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Inline_CSS.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}
		return static::$instance;
	}

	/**
	 * Constructor.
	 */
	public function __construct() {
		if ( ! is_admin() ) {
			return;
		}
		add_action( 'vc_after_init', [ $this, 'map_update' ] );
	}

	/**
	 * Updates WPBakery map.
	 */
	public function map_update() {
		if ( class_exists( 'Disable_Elements_For_WPBakery_Page_Builder' ) ) {
			$disabled_elements = get_option( 'wpex_wpb_disabled_elements' );
			if ( is_array( $disabled_elements ) ) {
				$this->shortcodes = array_diff( $this->shortcodes, $disabled_elements );
			}
		}
		foreach ( $this->shortcodes as $shortcode ) {
			vc_map_update( $shortcode, [
				'weight' => '-1',
			] );
		}
	}

}