<?php
namespace TotalTheme\Integration\WPBakery;

use TotalTheme\Restrict_Content;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery helper functions.
 *
 * @package TotalThemeCore
 * @version 1.6.1
 */
final class Helpers {

	/**
	 * Returns user access choices.
	 */
	public static function get_user_access_choices() {
		return [
			esc_html__( 'All', 'total' ) => '',
			esc_html__( 'Logged in', 'total' ) => 'logged_in',
			esc_html__( 'Logged out', 'total' ) => 'logged_out',
			esc_html__( 'First paginated page only', 'total' ) => 'not_paged',
			esc_html__( 'Custom', 'total' ) => 'custom',
		];
	}

	/**
	 * Returns choices for the user access option.
	 */
	public static function get_user_access_custom_choices() {
		$choices = [
			esc_html__( 'Select', 'total' ) => '',
		];
		$restrictions = Restrict_Content::instance()->get_custom_restrictions();
		if ( $restrictions ) {
			return array_merge( $choices, array_combine( $restrictions, $restrictions ) );
		}
		return $choices;
	}

	/**
	 * Check shortcode access.
	 */
	public static function shortcode_has_access( $atts = [] ) {
		if ( isset( $atts['vcex_user_access'] ) && ! is_admin() && ! vc_is_inline() ) {
			$callback = ( 'custom' === $atts['vcex_user_access'] && isset( $atts['vcex_user_access_callback'] ) ) ? $atts['vcex_user_access_callback'] : $atts['vcex_user_access'];
			if ( $callback && 'custom' !== $callback ) {
				return Restrict_Content::instance()->check_restriction( $callback );
			}
		}
		return true;
	}

	/**
	 * Returns correct post thumbnail id for dynamic settings such as background images.
	 */
	public static function get_post_thumbnail_id() {
		if ( in_the_loop() || get_query_var( 'wpex_card_object' ) ) {
			$post_id = get_the_ID();
		} else {
			$post_id = wpex_get_dynamic_post_id();
		}
		if ( $post_id ) {
			if ( 'attachment' === get_post_type( $post_id ) ) {
				$thumbnail_id = $post_id;
			} else {
				$thumbnail_id = get_post_thumbnail_id( $post_id );
			}
		} else {
			$thumbnail_id = wpex_get_term_thumbnail_id();
		}
		if ( isset( $thumbnail_id ) && 'attachment' === get_post_type( $thumbnail_id ) ) {
			return $thumbnail_id;
		}
	}

}