<?php
namespace TotalTheme\Integration\WooCommerce\Single;

defined( 'ABSPATH' ) || exit;

/**
 * Adds a flex container around the single product gallery and content.
 *
 * @package TotalTheme
 * @subpackage Integration/WooCommerce
 * @version 5.6
 */
final class Flex_Container {

	/**
	 * Instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of Thumbnails.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function init_hooks() {
		add_action( 'woocommerce_before_single_product_summary', [ $this, 'open_container' ], $this->open_priority() );
		add_action( 'woocommerce_after_single_product_summary', [ $this, 'close_container' ], $this->close_priority() );
	}

	/**
	 * Open container.
	 */
	public function open_container() {
		$bk         = $this->get_breakpoint();
		$class      = 'wpex-woocommerce-product-flex-container';
		$util_class = "wpex-{$bk}-flex wpex-{$bk}-flex-wrap wpex-{$bk}-justify-between";

		if ( get_theme_mod( 'woo_single_product_vertical_align' ) ) {
			$util_class .=  " wpex-{$bk}-items-center";
		}

		if ( get_theme_mod( 'woo_single_product_layout_reverse' ) ) {
			$class .=  ' wpex-woocommerce-product-flex-container--reverse';
			$util_class .= " wpex-{$bk}-flex-row-reverse";
		}

		$class = $class . ' || ' . $util_class;
		echo '<div class="' . esc_attr( $class ) . '">';
	}

	/**
	 * Close Container.
	 */
	public function close_container() {
		echo '</div>';
	}

	/**
	 * Container breakpoint.
	 */
	protected function get_breakpoint() {
		return apply_filters( 'totaltheme\integration\woocommerce\single\flex_container\breakpoint', 'md' );
	}

	/**
	 * Open Priority.
	 */
	protected function open_priority() {
		return (int) apply_filters( 'totaltheme\integration\woocommerce\single\flex_container\open_priority', 0 );
	}

	/**
	 * Close Priority.
	 */
	protected function close_priority() {
		return (int) apply_filters( 'totaltheme\integration\woocommerce\single\flex_container\close_priority', 0 );
	}

}