<?php
namespace TotalTheme\Integration;

defined( 'ABSPATH' ) || exit;

/**
 * WooCommerce Integration.
 *
 * @package TotalTheme
 * @subpackage Integration
 * @version 5.6.1
 */
final class WooCommerce {

	/**
	 * Instance.
	 *
	 * @access private
	 * @var object Class object.
	 */
	private static $instance;

	/**
	 * Create or retrieve the instance of WooCommerce.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', [ $this, 'wp_enqueue_scripts' ] );

		if ( wpex_has_woo_mods() && wpex_woo_version_supported() ) {
			WooCommerce\WooCommerce_Advanced::instance();
		} else {
			WooCommerce\WooCommerce_Vanilla::instance();
		}
	}

	/**
	 * Hooks into wp_enqueue_scripts.
	 */
	public function wp_enqueue_scripts() {
		wp_register_script(
			'wpex-wc-cart-dropdown',
			wpex_asset_url( 'js/dynamic/woocommerce/wpex-wc-cart-dropdown.min.js' ),
			[ WPEX_THEME_JS_HANDLE ],
			WPEX_THEME_VERSION,
			true
		);

		wp_register_script(
			'wpex-wc-cart-overlay',
			wpex_asset_url( 'js/dynamic/woocommerce/wpex-wc-cart-overlay.min.js' ),
			[ WPEX_THEME_JS_HANDLE ],
			WPEX_THEME_VERSION,
			true
		);
	}

}