<?php
namespace TotalTheme\Header;

use TotalTheme\Header\Core as Header;

defined( 'ABSPATH' ) || exit;

/**
 * Header Aside.
 *
 * @package TotalTheme
 * @subpackage Header
 * @version 5.6.1
 */
class Aside {

	/**
	 * Stores the header aside template id if defined.
	 */
	protected static $template_id;

	/**
	 * Returns array of header styles that allow aside content.
	 *
	 * @todo rename filter
	 */
	public static function supported_header_styles() {
		$supported_styles = [ 'two', 'three', 'four', 'dev' ];

		/**
		 * Filters the header styles that support the header aside area.
		 *
		 */
		$supported_styles = (array) apply_filters( 'totaltheme/header/aside/supported_header_styles', $supported_styles );

		/*** deprecated ****/
		$supported_styles = (array) apply_filters( 'wpex_get_header_styles_with_aside_support', $supported_styles );

		return $supported_styles;
	}

	/**
	 * Check if the header aside area is supported by the current theme setup.
	 */
	public static function is_supported() {
		$check = false;

		if ( in_array( Header::style(), self::supported_header_styles() ) ) {
			$check = true;
		}

		/**
		 * Filters if the header supports the "aside" element.
		 *
		 * @param bool $check
		 */
		$check = (bool) apply_filters( 'totaltheme/header/aside/is_supported', $check );

		/*** deprecated ***/
		$check = (bool) apply_filters( 'wpex_header_supports_aside', $check );

		return $check;
	}

	/**
	 * Return the aside content from the theme mod.
	 */
	private static function get_content_from_mod() {
		return wpex_get_translated_theme_mod( 'header_aside' );
	}

	/**
	 * Return template ID.
	 */
	public static function get_template_id() {
		if ( ! is_null( self::$template_id ) ) {
			return self::$template_id;
		}
		$template_id = ''; // make sure it isn't null to prevent extra checks.
		$content = self::get_content_from_mod();
		if ( is_numeric( $content ) ) {
			$post_id = wpex_parse_obj_id( $content, 'page' );
			$post    = get_post( $post_id );
			if ( $post && ! is_wp_error( $post ) ) {
				$template_id = $post_id;
			}
		}
		self::$template_id = $template_id;
		return self::$template_id;
	}

	/**
	 * Return header aside content.
	 */
	public static function get_content() {
		$template_id = self::get_template_id();

		if ( $template_id ) {
			$content = wpex_parse_vc_content( get_post_field( 'post_content', $template_id ) );
		} else {
			$content = self::get_content_from_mod();
		}

		/**
		 * Filters the header aside content.
		 *
		 * @param string $content
		 */
		$content = (string) apply_filters( 'totaltheme/header/aside/content', $content );

		/*** deprecated ***/
		$content = (string) apply_filters( 'wpex_header_aside_content', $content );

		return $content;
	}

	/**
	 * Echo class attribute for the the header aside wrapper element.
	 */
	public static function wrapper_class() {
		$class        = [];
		$header_style = Header::style();
		$visibility   = get_theme_mod( 'header_aside_visibility', 'hide-at-mm-breakpoint' );

		if ( $header_style ) {
			$class[] = 'header-' . sanitize_html_class( $header_style ) . '-aside';
		}

		if ( get_theme_mod( 'header_flex_items', false ) ) {
			$class[] = 'wpex-ml-auto';
			$class[] = 'wpex-order-2';
		}

		if ( ! empty( $visibility ) ) {
			$class[] = wpex_visibility_class( $visibility );
		}

		/**
		 * Filters the header aside element class.
		 *
		 * @param array $class
		 */
		$class = (array) apply_filters( 'totaltheme/header/aside/wrapper_class', $class );

		/*** deprecated ***/
		$class = (array) apply_filters( 'wpex_header_aside_class', $class );

		if ( $class ) {
			echo 'class="' . esc_attr( implode( ' ', $class ) ) . '"';
		}
	}

}