<?php
namespace TotalTheme;

defined( 'ABSPATH' ) || exit;

/**
 * Hamburger Icon.
 *
 * @package TotalTheme
 * @version 5.4
 */
class Hamburger_Icon {

	/**
	 * Renders the hamburger icon.
	 */
	public static function render( $args = array() ) {
		$args = self::parse_args( $args );

		$icon = '<span class="' . esc_attr( self::get_class( $args ) ) . '" aria-hidden="true"><span></span></span>';

		/**
		 * Filters the theme hamburger icon html.
		 *
		 * @param string $icon_html
		 */
		$icon = (string) apply_filters( 'wpex_hamburger_icon', $icon, $args );

		return $icon;
	}

	/**
	 * Parses the hamburger icon args.
	 */
	protected static function parse_args( $args ) {
		$default_args = array(
			'toggle_state' => true,
			'rounded'      => false,
		);

		$args = wp_parse_args( $args, $default_args );

		/**
		 * Filters the hamburger icon args.
		 *
		 * @param array $args
		 */
		$args = (array) apply_filters( 'wpex_hamburger_icon_args', $args );

		return $args;
	}

	/**
	 * Returns class for the hamburger icon.
	 */
	protected static function get_class( $args ) {
		$class = 'wpex-hamburger-icon';

		if ( wp_validate_boolean( $args['rounded'] ) ) {
			$class .= ' wpex-hamburger-icon--rounded';
		}

		if ( wp_validate_boolean( $args['toggle_state'] ) ) {
			$class .= ' wpex-hamburger-icon--inactive';
			$animate = $args['animate'] ?? true;
			if ( $animate ) {
				$class .= ' wpex-hamburger-icon--animate';
			}
		}

		return $class;
	}

}