<?php
defined( 'ABSPATH' ) || exit;

/**
 * Renders theme svg html.
 *
 * @param string $svg The SVG we are going to display.
 * @param int $size The size to be used for the svg width and height.
 * @return html
 */
function wpex_svg( $file = '', $size = 20 ) {
	echo wpex_get_svg( $file, $size );
}

/**
 * Returns theme svg html.
 *
 * @param string $svg The SVG we are going to display.
 * @param int $size The size to be used for the svg width and height.
 * @return html
 */
function wpex_get_svg( $file = '', $size = 20 ) {
	if ( ! $file ) {
		return;
	}

	// Fallbacks prior to the 5.4.5 update.
	switch ( $file ) {
		case 'close':
			$file = 'material/close';
			break;
		case 'wp-spinner':
		case 'spinner':
			$file = 'loaders/wordpress';
			break;
		case 'total':
		case 'total-logo':
			$file = 'brands/total';
			break;
		case 'wpbakery-logo':
		case 'wpbakery':
			$file = 'brands/wpbakery';
			break;
		default:
			break;
	}

//	$file = str_replace( 'custom/', '', $file ); // @todo?
	$svg = locate_template( 'assets/svgs/' . $file . '.svg', false );

	if ( $svg ) {
		$svg = file_get_contents( $svg );
	}

	if ( $svg && $size ) {
		/*$class = 'wpex-svg';
		$svg_arr = explode( '/', $file, 2 );
		if ( isset( $svg_arr[0] ) ) {
			$class .= ' wpex-svg--' . $svg_arr[0] ;
		}
		if ( isset( $svg_arr[1] ) ) {
			$class .= ' wpex-svg--' . $svg_arr[1] ;
		}
		$svg = str_replace( '<svg', '<svg class="' . esc_attr( $class ) . '"', $svg );
		*/
		$svg = preg_replace( '/(width|height)="\d*"\s/', '', $svg, 1 );
		$svg = str_replace( '<svg', '<svg height="' . esc_attr( $size['height'] ?? $size ) . '" width="' . esc_attr( $size['width'] ?? $size ) . '"', $svg );
	}

	/**
	 * Filters svg icon output
	 *
	 * @param string $svg
	 */
	$svg = (string) apply_filters( 'wpex_svg', $svg, $svg, $size );

	return $svg;
}