<?php
defined( 'ABSPATH' ) || exit;

/*-----------------------------------------------------------------------------------*/
/* - Deprecated constants
/*-----------------------------------------------------------------------------------*/
define( 'WPEX_THEME_STYLE_HANGLE', WPEX_THEME_STYLE_HANDLE );
define( 'WPEX_THEME_JS_HANGLE', WPEX_THEME_JS_HANDLE );

/*-----------------------------------------------------------------------------------*/
/*  - Renamed functions
/*-----------------------------------------------------------------------------------*/
function wpex_header_has_menu() {
	return wpex_has_header_menu();
}

function wpex_header_has_mobile_menu() {
	return wpex_has_header_mobile_menu();
}

function wpex_post_has_slider( $post_id = '' ) {
	return wpex_has_post_slider( $post_id );
}

function wpex_post_has_gallery( $post_id = '' ) {
	return wpex_has_post_gallery( $post_id );
}

function wpex_pagejump( $pages = '', $range = 4, $echo = true ) {
	if ( $echo ) {
		echo wpex_get_archive_next_prev_links( $pages, $range );
	} else {
		return wpex_get_archive_next_prev_links( $pages, $range );
	}
}

function wpex_post_has_vc_content( $post_id = null ) {
	return wpex_has_post_wpbakery_content( $post_id );
}

function wpex_get_awesome_icons( $return = 'all', $default = 'none' ) {
	return wpex_ticons_list( $return, $default );
}

function wpex_has_footer_builder() {
	return wpex_has_custom_footer();
}

function wpex_display_callout() {
	return wpex_has_callout();
}

function wpex_display_page_header() {
	wpex_page_header();
}

function wpex_display_page_header_title() {
	wpex_page_header_title();
}

function wpex_header_layout() {
	return;// Do nothing, new function wpex_site_header is added via hook
}

function wpex_toggle_bar_active() {
	return wpex_has_togglebar();
}

function wpex_toggle_bar_btn() {
	return wpex_toggle_bar_button();
}

function wpex_post_layout() {
	echo wpex_content_area_layout();
}

function wpex_get_post_layout_class() {
	return wpex_content_area_layout();
}

function wpex_overlay_classname() {
	return wpex_overlay_classes();
}

function wpex_img_animation_classes() {
	return wpex_entry_image_animation_classes();
}

function wpex_post_entry_author_avatar_enabled() {
	return wpex_get_mod( 'blog_entry_author_avatar' );
}

function wpex_has_menu_search() {
	return true;
}

function wpex_single_meta_blocks() {
	return wpex_meta_blocks();
}

function gds_get_star_rating( $rating = '', $post_id = '' ) {
	return wpex_get_star_rating( $rating, $post_id );
}

function wpex_get_the_id() {
	return wpex_get_current_post_id();
}

function wpex_get_header_logo_width() {
	return wpex_header_logo_img_width();
}

function wpex_get_header_logo_height() {
	return wpex_header_logo_img_height();
}

function wpex_get_post_layout() {
	return wpex_content_area_layout();
}

function wpex_get_page_subheading() {
	return wpex_page_header_subheading_content();
}

function wpex_is_front_end_composer() {
	return wpex_vc_is_inline();
}

function wpex_breadcrumbs( $post_id = '' ) {
	$breadcrumbs = new WPEX_Breadcrumbs();
	$breadcrumbs->display();
}

function wpex_has_footer_widgets() {
	return wpex_footer_has_widgets();
}

function wpex_display_footer_widgets() {
	return wpex_footer_has_widgets();
}

function wpex_topbar_output() {
	return wpex_topbar_content();
}

function wpex_top_bar_classes() {
	return wpex_topbar_content_classes();
}

function wpex_footer_reveal_enabled( $post_id = '' ) {
	return wpex_footer_has_reveal( $post_id );
}

function wpex_footer_has_reveal( $post_id = '' ) {
	return wpex_has_footer_reveal();
}

function wpex_page_header_background_image_meta() {
	return wpex_page_header_background_image();
}

function wpex_toggle_bar_classes() {
	return wpex_togglebar_classes();
}

function wpex_portfolio_post_blocks() {
	return wpex_portfolio_single_blocks();
}

function wpex_staff_post_blocks() {
	return wpex_staff_single_blocks();
}

function wpex_ilightbox_stylesheet( $skin = null ) {
	return '';
}

function wpex_get_meta_awesome_icons() {
	return array();
}

function wpex_get_mobile_menu_extra_icons() {
	ob_start();
		wpex_mobile_menu_toggle_extra_icons();
	return ob_get_clean();

}

function wpex_get_social_items() {
	return wpex_social_share_items();
}

function wpex_has_callout() {
	return wpex_has_footer_callout();
}

function wpex_callout_content() {
	ob_start();
		wpex_footer_callout_content();
	return ob_get_clean();
}

function wpex_top_bar_content() {
	wpex_topbar_content();
}

/*-----------------------------------------------------------------------------------*/
/*  - Completely Deprecated functions
/*-----------------------------------------------------------------------------------*/

function wpex_get_mods() {
	_deprecated_function( 'wpex_get_mods', '5.0', 'get_theme_mods' );
}

function wpex_header_search_placeholder() {
	_deprecated_function( 'wpex_header_search_placeholder', '3.0.0' );
}

function wpex_option() {
	_deprecated_function( 'wpex_option', '1.6.0', 'wpex_get_mod' );
}

function wpex_image() {
	_deprecated_function( 'wpex_image', '2.0.0', 'wpex_get_post_thumbnail' );
}

function wpex_mobile_menu() {
	_deprecated_function( 'wpex_mobile_menu', '2.0.0', 'wpex_mobile_menu_icons' );
}

function wpex_post_has_composer() {
	_deprecated_function( 'wpex_post_has_composer', '2.0.0', 'wpex_has_composer' );
}

function wpex_display_header() {
	_deprecated_function( 'wpex_display_header', '2.0.0', 'wpex_has_header' );
}

function wpex_display_footer() {
	_deprecated_function( 'wpex_display_footer', '2.0.0', 'wpex_has_footer' );
}

function wpex_page_title() {
	_deprecated_function( 'wpex_page_title', '2.0.0', 'wpex_title' );
}

function wpex_post_subheading() {
	_deprecated_function( 'wpex_post_subheading', '2.0.0', 'wpex_page_header_subheading' );
}

function wpex_hook_header_before_default() {
	_deprecated_function( 'wpex_hook_header_before_default', '2.0.0' );
}

function wpex_hook_header_inner_default() {
	_deprecated_function( 'wpex_hook_header_inner_default', '2.0.0' );
}

function wpex_hook_header_bottom_default() {
	_deprecated_function( 'wpex_hook_header_bottom_default', '2.0.0' );
}

function wpex_hook_main_top_default() {
	_deprecated_function( 'wpex_hook_main_top_default', '2.0.0' );
}

function wpex_hook_sidebar_inner_default() {
	_deprecated_function( 'wpex_hook_sidebar_inner_default', '2.0.0' );
}

function wpex_hook_footer_before_default() {
	_deprecated_function( 'wpex_hook_footer_before_default', '2.0.0' );
}

function wpex_hook_footer_inner_default() {
	_deprecated_function( 'wpex_hook_footer_inner', '2.0.0' );
}

function wpex_hook_footer_after_default() {
	_deprecated_function( 'wpex_hook_footer_after', '2.0.0' );
}

function wpex_hook_wrap_after_default() {
	_deprecated_function( 'wpex_hook_wrap_after_default', '2.0.0' );
}

function wpex_theme_setup() {
	_deprecated_function( 'wpex_theme_setup', '1.6.0' );
}

function wpex_active_post_types() {
	_deprecated_function( 'wpex_active_post_types', '1.6.0' );
}

function wpex_jpeg_quality() {
	_deprecated_function( 'wpex_jpeg_quality', '1.6.0' );
}

function wpex_favicons() {
	_deprecated_function( 'wpex_favicons', '1.6.0' );
}

function wpex_get_woo_product_first_cat() {
	_deprecated_function( 'wpex_get_woo_product_first_cat', '1.6.0' );
}

function wpex_global_config() {
	_deprecated_function( 'wpex_global_config', '1.6.0' );
}

function wpex_ie8_css() {
	_deprecated_function( 'wpex_ie8_css', '1.6.0' );
}

function wpex_html5() {
	_deprecated_function( 'wpex_html5', '1.6.0' );
}

function wpex_load_scripts() {
	_deprecated_function( 'wpex_load_scripts', '1.6.0' );
}

function wpex_remove_wp_ver_css_js() {
	_deprecated_function( 'wpex_remove_wp_ver_css_js', '1.6.0' );
}

function wpex_output_css() {
	_deprecated_function( 'wpex_output_css', '1.6.0' );
}

function wpex_header_output() {
	_deprecated_function( 'wpex_header_output', '1.6.0', 'wpex_header_layout' );
}

function wpex_footer_copyright() {
	_deprecated_function( 'wpex_footer_copyright', '1.6.0', 'get_template_part' );
}

function wpex_top_bar_social() {
	_deprecated_function( 'wpex_top_bar_social', '1.6.0', 'get_template_part' );
}

function wpex_portfolio_single_media() {
	_deprecated_function( 'wpex_portfolio_single_media', '1.6.0', 'get_template_part' );
}

function wpex_portfolio_related() {
	_deprecated_function( 'wpex_portfolio_related', '1.6.0', 'get_template_part' );
}

function wpex_staff_entry_media() {
	_deprecated_function( 'wpex_staff_entry_media', '1.6.0', 'get_template_part' );
}

function wpex_staff_related() {
	_deprecated_function( 'wpex_staff_related', '1.6.0', 'get_template_part' );
}

function wpex_blog_related() {
	_deprecated_function( 'wpex_blog_related', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_display() {
	_deprecated_function( 'wpex_blog_entry_display', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_image() {
	_deprecated_function( 'wpex_blog_entry_image', '1.6.0', 'get_template_part' );
}

function wpex_post_entry_author_avatar() {
	_deprecated_function( 'wpex_post_entry_author_avatar', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_title() {
	_deprecated_function( 'wpex_blog_entry_title', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_header() {
	_deprecated_function( 'wpex_blog_entry_header', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_content() {
	_deprecated_function( 'wpex_blog_entry_content', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_media() {
	_deprecated_function( 'wpex_blog_entry_media', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_link_format_image() {
	_deprecated_function( 'wpex_blog_entry_link_format_image', '1.6.0', 'get_template_part' );
}

function wpex_post_readmore_link() {
	_deprecated_function( 'wpex_post_readmore_link', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_video() {
	_deprecated_function( 'wpex_blog_entry_video', '1.6.0', 'get_template_part' );
}

function wpex_blog_entry_audio() {
	_deprecated_function( 'wpex_blog_entry_audio', '1.6.0', 'get_template_part' );
}

function wpex_post_meta() {
	_deprecated_function( 'wpex_post_meta', '1.6.0', 'get_template_part' );
}

function wpex_post_entry_classes() {
	_deprecated_function( 'wpex_post_entry_classes', '1.6.0' );
}

function vcex_advanced_parallax() {
	_deprecated_function( 'vcex_advanced_parallax', '2.0.2', 'vcex_parallax_bg' );
}

function vcex_front_end_carousel_js() {
	_deprecated_function( 'vcex_front_end_carousel_js', '2.0.0', 'vcex_inline_js' );
}

function wpex_breadcrumbs_get_parents() {
	_deprecated_function( 'wpex_breadcrumbs_get_parents', '3.0.9' );
}

function wpex_breadcrumbs_get_term_parents() {
	_deprecated_function( 'wpex_breadcrumbs_get_term_parents', '3.0.9' );
}

function wpex_vc_column_inner_extra_attributes() {
	_deprecated_function( 'wpex_vc_column_inner_extra_attributes', '4.1' );
}

function wpex_global_obj() {
	_deprecated_function( 'wpex_get_mods', '4.0' );
}

function wpex_landing_page_remove_actions() {
	_deprecated_function( 'wpex_landing_page_remove_actions', '5.0' );
}

function wpex_element() {
	_deprecated_function( 'wpex_element', '5.0' );
}

function wpex_is_mod_enabled() {
	_deprecated_function( 'wpex_validate_boolean', '5.0' );
}

function wpex_portfolio_first_cat() {
	_deprecated_function( 'wpex_get_first_term', '5.0' );
}

function wpex_portfolio_cats() {
	_deprecated_function( 'wpex_list_post_terms', '5.0' );
}

function wpex_enqueue_archive_scripts() {
	_deprecated_function( 'wpex_enqueue_archive_scripts', '5.0' );
}

function wpex_posts_columns() {
	_deprecated_function( 'wpex_posts_columns', '5.0.6' );
}

function wpex_posts_custom_columns() {
	_deprecated_function( 'wpex_posts_custom_columns', '5.0.6' );
}

function wpex_vc_add_params() {
	_deprecated_function( 'wpex_vc_add_params', '5.1.1' );
}

function wpex_vc_modify_params() {
	_deprecated_function( 'wpex_vc_modify_params', '5.1.1' );
}

function wpex_portfolio_style_supports_equal_heights() {
	return;
}

function wpex_page_header_title_table_wrap_open() {
	return;
}

function wpex_page_header_title_table_wrap_close() {
	return;
}

function wpex_envato_hosted() {
	return;
}

function wpex_portfolio_entry_terms() {
	return;
}

function wpex_enqueue_font_awesome_in_admin() {
	return;
}

function wpex_custom_widgets_list() {
	return array();
}

function wpex_social_sharing_supports_heading() {
	return wpex_has_social_share_heading();
}

function wpex_string_to_array( $list ) {
	return wpex_parse_list( $list );
}

function wpex_sidr_close() {
	return;
}

function vcex_parse_deprecated_row_css() {
	return;
}

function vcex_offset_vc() {
	return;
}

/*-----------------------------------------------------------------------------------*/
/*  4.9.3 Lightbox switch
/*-----------------------------------------------------------------------------------*/
function wpex_enqueue_ilightbox_scripts() {
	wpex_enqueue_lightbox_scripts();
}

function wpex_enqueue_ilightbox_skin() {
	wpex_enqueue_lightbox_scripts();
}

function wpex_ilightbox_skins() {
	return array();
}

function wpex_ilightbox_skin() {
	return 'default';
}

/*-----------------------------------------------------------------------------------*/
/*  5.1.2
/*-----------------------------------------------------------------------------------*/
function wpex_grid_class( $columns = '4' ) {
	return wpex_row_column_width_class( $columns );
}

function vcex_parallax_bg( $atts = array() ) {
	_deprecated_function( 'vcex_parallax_bg', '5.3', 'TotalTheme\\Integration\\WPBakery::render_parallax_bg' );
}

function wpex_header_logo_img_retina_js() {
	_deprecated_function( 'wpex_header_logo_img_retina_js', '5.1', '' );
}

function wpex_register_admin_scripts() {
	_deprecated_function( 'wpex_register_admin_scripts', '5.1', '' );
}

function wpex_ticons_admin_enqueue( $hook ) {
	_deprecated_function( 'wpex_ticons_admin_enqueue', '5.1', '' );
}

function wpex_custom_excerpt_length() {
	_deprecated_function( 'wpex_custom_excerpt_length', '5.1', '' );
}

/*-----------------------------------------------------------------------------------*/
/*  5.3.1
/*-----------------------------------------------------------------------------------*/
function wpex_header_logo_img_retina_height() {
	_deprecated_function( 'wpex_custom_excerpt_length', '5.3.1', '' );
}
function wpex_overlay_header_logo_img_retina_height() {
	_deprecated_function( 'wpex_overlay_header_logo_img_retina_height', '5.3.1', '' );
}
function wpex_sticky_header_logo_img_retina_height() {
	_deprecated_function( 'wpex_sticky_header_logo_img_retina_height', '5.3.1', '' );
}

/*-----------------------------------------------------------------------------------*/
/*  5.4
/*-----------------------------------------------------------------------------------*/
function wpex_blank_img_src() {
	_deprecated_function( 'wpex_custom_excerpt_length', '5.4', '' );
}

/*-----------------------------------------------------------------------------------*/
/*  5.4
/*-----------------------------------------------------------------------------------*/
function wpex_woocommerce_before_add_to_cart_button_open_flex_wrap() {
	_deprecated_function( 'wpex_woocommerce_before_add_to_cart_button_open_flex_wrap', '5.4', '' );
}
function wpex_woocommerce_before_add_to_cart_button_close_flex_wrap() {
	_deprecated_function( 'wpex_woocommerce_before_add_to_cart_button_close_flex_wrap', '5.4', '' );
}
function wpex_js_localize_data() {
	_deprecated_function( 'wpex_js_localize_data', '5.4', '' );
}
function wpex_register_scripts() {
	_deprecated_function( 'wpex_register_scripts', '5.4', 'TotalTheme\\Scripts\\JS\\::register' );
}
function wpex_enqueue_front_end_main_css() {
	_deprecated_function( 'wpex_enqueue_front_end_main_css', '5.4', 'TotalTheme\\Scripts\\CSS\\::enqueue' );
}
function wpex_enqueue_front_end_js() {
	_deprecated_function( 'wpex_enqueue_front_end_js', '5.4', 'TotalTheme\\Initialize\\::scripts' );
}
function wpex_body_class() {
	_deprecated_function( 'wpex_body_class', '5.4', 'TotalTheme\\Body_Class::add_classes' );
}
function wpex_widget_tag_cloud_args() {
	_deprecated_function( 'wpex_widget_tag_cloud_args', '5.4', 'TotalTheme\\Widgets\\Tag_Cloud::args' );
}
function wpex_post_class() {
	_deprecated_function( 'wpex_post_class', '5.4', 'TotalTheme\\Post_Class::add_classes' );
}
function wpex_pre_get_posts( $query ) {
	_deprecated_function( 'wpex_pre_get_posts', '5.4', 'TotalTheme\\Pre_Get_Posts::set_query' );
}
function wpex_post_redirect() {
	_deprecated_function( 'wpex_post_redirect', '5.4', 'TotalTheme\\Redirections::maybe_redirect' );
}
function wpex_site_overlay() {}

/*-----------------------------------------------------------------------------------*/
/*  5.4.2
/*-----------------------------------------------------------------------------------*/
function wpex_blog_single_layout_blocks() {
	return TotalTheme\Blog\Single_Blocks::get();
}
function wpex_portfolio_single_blocks() {
	return TotalTheme\Portfolio\Single_Blocks::get();
}
function wpex_staff_single_blocks() {
	return TotalTheme\Staff\Single_Blocks::get();
}

function wpex_page_single_blocks_class() {
	TotalTheme\Page\Single_Blocks::wrapper_class();
}
function wpex_blog_single_blocks_class() {
	TotalTheme\Blog\Single_Blocks::wrapper_class();
}
function wpex_portfolio_single_blocks_class() {
	TotalTheme\Portfolio\Single_Blocks::wrapper_class();
}
function wpex_staff_single_blocks_class() {
	TotalTheme\Staff\Single_Blocks::wrapper_class();
}
function wpex_cpt_single_blocks_class() {
	TotalTheme\CPT\Single_Blocks::wrapper_class();
}

function wpex_blog_entry_layout_blocks() {
	return TotalTheme\Blog\Entry_Blocks::get();
}
function wpex_entry_blocks() {
	return TotalTheme\CPT\Entry_Blocks::get();
}
function wpex_meta_blocks() {
	return TotalTheme\CPT\Meta_Blocks::get();
}

function wpex_blog_entry_meta_sections() {
	return TotalTheme\Blog\Meta_Blocks::get( false );
}
function wpex_blog_single_meta_sections() {
	return TotalTheme\Blog\Meta_Blocks::get( true );
}
function wpex_portfolio_single_meta_sections() {
	return TotalTheme\Portfolio\Meta_Blocks::get( true );
}
function wpex_staff_single_meta_sections() {
	return TotalTheme\Staff\Meta_Blocks::get( true );
}

function wpex_cpt_meta_class( $is_custom = false ) {
	TotalTheme\CPT\Meta_Blocks::wrapper_class( $is_custom );
}
function wpex_blog_entry_meta_class() {
	TotalTheme\Blog\Meta_Blocks::wrapper_class( false );
}
function wpex_blog_single_meta_class() {
	TotalTheme\Blog\Meta_Blocks::wrapper_class( true );
}
function wpex_portfolio_single_meta_class() {
	TotalTheme\Portfolio\Meta_Blocks::wrapper_class( true );
}
function wpex_staff_single_meta_class() {
	TotalTheme\Staff\Meta_Blocks::wrapper_class( true );
}

/*-----------------------------------------------------------------------------------*/
/*  5.4.3
/*-----------------------------------------------------------------------------------*/

// Converted logo functions into a singular class.
function wpex_header_logo_img( $parse_logo = true ) {
	if ( $parse_logo ) {
		return TotalTheme\Header\Logo::get_image_url();
	} else {
		return TotalTheme\Header\Logo::get_image_id();
	}
}
function wpex_header_logo_text() {
	return TotalTheme\Header\Logo::get_text();
}
function wpex_header_logo_title() {
	return TotalTheme\Header\Logo::get_text();
}
function wpex_header_logo_img_retina() {
	return TotalTheme\Header\Logo::get_retina_image_url();
}
function wpex_header_logo_icon() {
	return TotalTheme\Header\Logo::get_icon();
}
function wpex_header_logo_class() {
	TotalTheme\Header\Logo::wrapper_class();
}
function wpex_header_logo_classes() {
	return TotalTheme\Header\Logo::get_wrapper_classes();
}
function wpex_header_logo_inner_class() {
	return TotalTheme\Header\Logo::inner_class();
}
function wpex_header_logo_img_src() {
	return TotalTheme\Header\Logo::get_image_src();
}
function wpex_header_logo_img_class() {
	return TotalTheme\Header\Logo::get_image_class();
}
function wpex_header_has_text_logo() {
	return ! TotalTheme\Header\Logo::get_image_url();
}
function wpex_header_logo_img_width() {
	return TotalTheme\Header\Logo::get_image_width();
}
function wpex_header_logo_img_height() {
	return TotalTheme\Header\Logo::get_image_height();
}
function wpex_header_logo_img_is_svg() {
	return TotalTheme\Header\Logo::is_image_svg();
}
function wpex_header_logo_txt_class() {
	return TotalTheme\Header\Logo::get_text_class();
}
function wpex_header_logo_url() {
	return TotalTheme\Header\Logo::get_link_url();
}
function wpex_header_logo_scroll_top() {
	return TotalTheme\Header\Logo::has_scroll_top_link();
}
function wpex_header_inner_class() {
	return TotalTheme\Header\Core::inner_class();
}
function wpex_header_has_fixed_height( $header_style = 'deprecated' ) {
	return TotalTheme\Header\Core::has_fixed_height();
}
function wpex_has_flex_header() {
	return TotalTheme\Header\Core::has_flex_container();
}
function wpex_header_classes() {
	return TotalTheme\Header\Core::get_wrapper_classes();
}
function wpex_header_background_image() {
	return TotalTheme\Header\Core::get_background_image_url();
}
function wpex_header_menu_mobile_style() {
	return TotalTheme\Mobile\Menu::style();
}
function wpex_header_style( $post_id = 'deprecated' ) {
	return TotalTheme\Header\Core::style();
}
function wpex_has_header_mobile_menu() {
	return TotalTheme\Mobile\Menu::is_enabled();
}
function wpex_header_menu_mobile_breakpoint() {
	return TotalTheme\Mobile\Menu::breakpoint();
}
function wpex_overlay_header_style() {
	return TotalTheme\Header\Overlay::style();
}
function wpex_is_overlay_header_global() {
	return TotalTheme\Header\Overlay::is_global();
}
function wpex_overlay_header_logo_img( $parse_logo = true ) {
	return TotalTheme\Header\Overlay::logo_img( $parse_logo );
}
function wpex_overlay_header_logo_img_retina() {
	return TotalTheme\Header\Overlay::logo_img_retina();
}
function wpex_has_overlay_header() {
	return TotalTheme\Header\Overlay::is_enabled();
}

/*-----------------------------------------------------------------------------------*/
/*  5.4.5
/*-----------------------------------------------------------------------------------*/

// header aside
function wpex_header_aside_class() {
	return TotalTheme\Header\Aside::wrapper_class();
}
function wpex_header_supports_aside( $header_style = 'deprecated' ) {
	return TotalTheme\Header\Aside::is_supported();
}
function wpex_header_aside_content() {
	return TotalTheme\Header\Aside::get_content();
}
function wpex_get_header_styles_with_aside_support() {
	return TotalTheme\Header\Aside::supported_header_styles();
}

// topbar
function wpex_has_topbar( $post_id = 'deprecated' ) {
	return TotalTheme\Topbar\Core::is_enabled();
}
function wpex_topbar_style() {
	return TotalTheme\Topbar\Core::style();
}
function wpex_topbar_split_breakpoint() {
	return TotalTheme\Topbar\Core::breakpoint();
}
function wpex_topbar_is_fullwidth() {
	return TotalTheme\Topbar\Core::is_fullwidth();
}
function wpex_has_topbar_content() {
	return TotalTheme\Topbar\Core::has_content();
}
function wpex_topbar_wrap_class() {
	TotalTheme\Topbar\Core::wrapper_class();
}
function wpex_topbar_classes() {
	return TotalTheme\Topbar\Core::get_wrapper_classes();
}
function wpex_topbar_class() {
	TotalTheme\Topbar\Core::inner_class();
}
function wpex_topbar_content( $deprecated = '' ) {
	return TotalTheme\Topbar\Core::get_content();
}
function wpex_topbar_content_class() {
	TotalTheme\Topbar\Core::content_class();
}
function wpex_topbar_content_classes() {
	return TotalTheme\Topbar\Core::get_content_classes();
}
function wpex_has_topbar_social() {
	return TotalTheme\Topbar\Social::is_enabled();
}
function wpex_topbar_social_alt_content( $deprecated = '' ) {
	return TotalTheme\Topbar\Social::get_alt_content();
}
function wpex_topbar_social_style() {
	return TotalTheme\Topbar\Social::get_icon_style();
}
function wpex_topbar_social_class() {
	TotalTheme\Topbar\Social::wrapper_class();
}
function wpex_topbar_social_list() {
	TotalTheme\Topbar\Social::render_list();
}
function wpex_get_topbar_social_profiles() {
	return TotalTheme\Topbar\Social::get_registered_profiles();
}
function wpex_topbar_social_options() {
	return TotalTheme\Topbar\Social::get_profile_options();
}

function wpex_infinite_scroll() {
	_deprecated_function( 'wpex_infinite_scroll', '5.4.5', '' );
}

function wpex_get_loadmore_text() {
	return TotalTheme\Pagination\Load_More::get_more_text();
}

function wpex_get_loadmore_loading_text() {
	return TotalTheme\Pagination\Load_More::get_loading_text();
}

function wpex_get_loadmore_failed_text() {
	return TotalTheme\Pagination\Load_More::get_failed_text();
}

function wpex_get_loadmore_gif() {
	return TotalTheme\Pagination\Load_More::get_loader_gif();
}

function wpex_enqueue_loadmore_scripts() {
	TotalTheme\Pagination\Load_More::enqueue_scripts();
}

function wpex_loadmore( $args = array() ) {
	TotalTheme\Pagination\Load_More::render_button( $args );
}

function wpex_get_loadmore_data( $key = '' ) {
	return TotalTheme\Pagination\Load_More::get_data( $key );
}

function wpex_str_starts_with( $haystack = '', $needle = '' ) {
	return str_starts_with( $haystack, $needle );
}

if ( ! function_exists( 'wpex_blog_pagination' ) ) {
	function wpex_blog_pagination( $args = array() ) {
		TotalTheme\Pagination\Core::render( 'blog' );
	}
}

function wpex_archive_next_prev_links( $query = '' ) {
	$pagination = new TotalTheme\Pagination\Next_Prev( $query );
	$pagination->render();
}

function wpex_get_archive_next_prev_links( $query = '' ) {
	$pagination = new TotalTheme\Pagination\Next_Prev( $query );
	ob_start();
		$pagination->render();
	return ob_get_clean();
}

if ( ! function_exists( 'wpex_pagination' ) ) {
	function wpex_pagination( $query = '', $echo = true ) {
		$pagination = new TotalTheme\Pagination\Standard( $query );
		if ( $echo ) {
			$pagination->render();
		} else {
			ob_start();
				$pagination->render();
			return ob_get_clean();
		}
	}
}

function wpex_get_pagination() {
	$arrow_icon = sanitize_html_class( get_theme_mod( 'pagination_arrow' ) ?: 'angle' );

	if ( is_rtl() ) {
		$prev_arrow = $arrow_icon . '-right';
		$next_arrow = $arrow_icon . '-left';
	} else {
		$prev_arrow = $arrow_icon . '-left';
		$next_arrow = $arrow_icon . '-right';
	}

	return get_the_posts_pagination( array(
		'type' => 'list',
		'prev_text' => wpex_get_theme_icon_html( $prev_arrow ) . '<span class="screen-reader-text">' . esc_html__( 'Previous', 'total' ) . '</span>',
		'next_text' => wpex_get_theme_icon_html( $next_arrow ) . '<span class="screen-reader-text">' . esc_html__( 'Next', 'total' ) . '</span>',
		'before_page_number' => '<span class="screen-reader-text">' . esc_html__( 'Page', 'total' ) . ' </span>',
	) );
}

function wpex_has_footer_bottom( $post_id = 'deprecated' ) {
	return TotalTheme\Footer\Bottom\Core::is_enabled();
}

function wpex_footer_bottom_class() {
	TotalTheme\Footer\Bottom\Core::wrapper_class();
}

function wpex_footer_bottom_menu_class() {
	TotalTheme\Footer\Bottom\Menu::wrapper_class();
}

function wpex_vc_meta_inline_style( $id = '' ) {
	TotalTheme\Integration\WPBakery\Shortcode_Inline_Style::instance()->render_style( $post_id );
}

function wpex_get_vc_meta_inline_style( $post_id = 0 ) {
	return TotalTheme\Integration\WPBakery\Shortcode_Inline_Style::instance()->get_style( $post_id );
}

function wpex_has_singular_template() {
	return TotalTheme\Theme_Builder\Post_Template::has_template();
}

function wpex_get_singular_template_id( $post_type = '' ) {
	return TotalTheme\Theme_Builder\Post_Template::get_template_id( $post_type );
}

function wpex_get_singular_template_content( $post_type = '' ) {
	return TotalTheme\Theme_Builder\Post_Template::get_template_content( $post_type );
}

function wpex_singular_template( $template_content = '' ) {
	echo TotalTheme\Theme_Builder\Post_Template::render_template( $template_content );
}

function wpex_has_sticky_header() {
	return TotalTheme\Header\Sticky::is_enabled();
}

function wpex_sticky_header_style() {
	return TotalTheme\Header\Sticky::style();
}

function wpex_sticky_header_logo_img_src() {
	return TotalTheme\Header\Sticky::get_logo_image_src();
}

function wpex_sticky_header_logo_img() {
	return TotalTheme\Header\Sticky::get_logo_image_url();
}

function wpex_sticky_header_logo_img_height() {
	return TotalTheme\Header\Sticky::get_logo_image_height();
}

function wpex_sticky_header_logo_img_width() {
	return TotalTheme\Header\Sticky::get_logo_image_width();
}

function wpex_sticky_header_logo_img_retina() {
	return TotalTheme\Header\Sticky::get_retina_logo_image_url();
}

function wpex_has_shrink_sticky_header() {
	return TotalTheme\Header\Sticky::is_shrink_enabled();
}

function wpex_has_shrink_sticky_header_mobile() {
	return TotalTheme\Header\Sticky::is_shrink_enabled_mobile();
}

function wpex_sticky_header_start_position() {
	return TotalTheme\Header\Sticky::get_start_position();
}

/*-----------------------------------------------------------------------------------*/
/*  5.6
/*-----------------------------------------------------------------------------------*/
function wpex_header_menu_supports_search() {
	return TotalTheme\Header\Menu\Search::is_supported();
}
function wpex_header_menu_search_style() {
	return TotalTheme\Header\Menu\Search::style();
}
function wpex_get_header_menu_search_form() {
	return TotalTheme\Header\Menu\Search::get_form();
}
function wpex_get_header_menu_search_form_placeholder() {
	return TotalTheme\Header\Menu\Search::get_placeholder_text();
}
function wpex_add_search_to_menu( $items, $args ) {
	return $items;
}
function wpex_header_drop_widget_search_class() {
	return TotalTheme\Header\Menu\Search::drop_widget_class();
}
function wpex_sidebar_class() {
	TotalTheme\Sidebars\Primary::wrapper_class();
}
function wpex_sidebar_inner_class() {
	TotalTheme\Sidebars\Primary::inner_class();
}
function wpex_get_sidebar( $sidebar = '', $post_id = '' ) {
	return TotalTheme\Sidebars\Primary::get_sidebar_name();
}

/*-----------------------------------------------------------------------------------*/
/*  5.6.1
/*-----------------------------------------------------------------------------------*/
function wpex_title( $post_id = '' ) {
	if ( $post_id ) {
		return TotalTheme\Title::instance()->get_unfiltered_post_title( $post_id );
	}
	return TotalTheme\Title::instance()->get();
}

function vcex_insert_top_shape_divider() {
	_deprecated_function( 'vcex_insert_top_shape_divider', '5.6.1' );
}
function vcex_insert_bottom_shape_divider() {
	_deprecated_function( 'vcex_insert_top_shape_divider', '5.6.1' );
}
function wpex_get_shape_divider_types() {
	_deprecated_function( 'wpex_get_shape_divider_types', '5.6.1' );
}
function wpex_get_shape_divider_settings() {
	_deprecated_function( 'wpex_get_shape_divider_settings', '5.6.1' );
}
function wpex_shape_divider_rotate( $position, $type, $invert ) {
	_deprecated_function( 'wpex_shape_divider_rotate', '5.6.1' );
}
function wpex_get_shape_divider( $position = 'top', $type = 'deprecated', $atts = [] ) {
	return TotalTheme\Shape_Dividers::instance()->get_divider( $position, $atts );
}
function wpex_get_shape_dividers_svg( $type = '', $settings = [] ) {
	return TotalTheme\Shape_Dividers::instance()->get_svg( $type, $settings );
}

function wpex_has_local_scroll_on_load() {
	return TotalTheme\Local_Scroll::instance()->is_feature_enabled( 'scroll_to_hash' );
}
function wpex_has_local_scroll_menu_highlight() {
	return TotalTheme\Local_Scroll::instance()->is_feature_enabled( 'highlight' );
}
function wpex_has_local_scroll_hash_update() {
	return TotalTheme\Local_Scroll::instance()->is_feature_enabled( 'update_hash' );
}
function wpex_get_local_scroll_on_load_timeout() {
	return TotalTheme\Local_Scroll::instance()->get_onload_timeout_time();
}
function wpex_get_local_scroll_targets() {
	return TotalTheme\Local_Scroll::instance()->get_trigger_targets();
}
function wpex_get_local_scroll_speed() {
	return TotalTheme\Local_Scroll::instance()->get_scroll_to_duration();
}
function wpex_get_local_scroll_easing() {
    return TotalTheme\Local_Scroll::instance()->get_easing_function();
}
function wpex_register_footer_widget_area( $args = [] ) {
	new TotalTheme\Helpers\Register_Widget_Area( 'footer', $args );
}
function wpex_register_sidebar( $args = [] ) {
	new TotalTheme\Helpers\Register_Widget_Area( 'sidebar', $args );
}

function wpex_footer_has_widgets() {
	return TotalTheme\Footer\Widgets::is_enabled();
}

function wpex_header_flex_aside_class() {
	return TotalTheme\Header\Flex\Aside::wrapper_class();
}
function wpex_header_flex_aside_content() {
	return TotalTheme\Header\Flex\Aside::get_content();
}

function wpex_has_footer_callout() {
	return TotalTheme\Footer\Callout::is_enabled();
}
function wpex_footer_callout_content() {
	$content = TotalTheme\Footer\Callout::get_content();
	if ( $content ) {
		echo do_shortcode( wp_kses_post( $content ) );
	}
}
function wpex_footer_callout_button() {
	$button = TotalTheme\Footer\Callout::get_button();
	if ( $button ) {
		echo wp_kses_post( $button );
	}
}
function wpex_footer_callout_wrap_class() {
	TotalTheme\Footer\Callout::wrapper_class();
}
function wpex_footer_callout_class() {
	TotalTheme\Footer\Callout::inner_class();
}
function wpex_footer_callout_left_class() {
	TotalTheme\Footer\Callout::content_class();
}
function wpex_footer_callout_right_class() {
	TotalTheme\Footer\Callout::button_class();
}
function wpex_has_footer_callout_content( ) {
	return (bool) wpex_callout_content();
}
function wpex_has_footer_callout_button( ) {
	if ( wpex_footer_callout_button_link() && wpex_footer_callout_button_text() ) {
		return true;
	}
	return false;
}
function wpex_footer_callout_button_link() {
	return TotalTheme\Footer\Callout::get_button_link();
}
function wpex_footer_callout_button_text() {
	return TotalTheme\Footer\Callout::get_button_text();
}
function wpex_footer_callout_button_icon() {
	return TotalTheme\Footer\Callout::get_button_icon();
}

function wpex_has_footer() {
	return TotalTheme\Footer\Core::is_enabled();
}
function wpex_has_footer_reveal( $post_id = 'deprecated' ) {
	return TotalTheme\Footer\Core::has_reveal();
}
function wpex_footer_class() {
	$classes = TotalTheme\Footer\Core::get_wrapper_classes();
	if ( $classes ) {
		return implode( ' ', $classes );
	}
}
function wpex_footer_widgets_class() {
	$class = TotalTheme\Footer\Widgets::get_wrapper_classes();
	if ( $class && is_array( $class ) ) {
		$class = apply_filters( 'wpex_footer_widget_row_classes', implode( ' ', $class ) );
		return $class;
	}
}