<?php
defined( 'ABSPATH' ) || exit;

$breakpoints = wpex_utl_breakpoints();

if ( $breakpoints && is_array( $breakpoints ) ) {
	$breakpoints['none'] = esc_html__( 'None (no stacking)', 'total' );
}

// General.
$this->sections['wpex_topbar_general'] = array(
	'title' => esc_html__( 'General', 'total' ),
	'panel' => 'wpex_topbar',
	'settings' => array(
		array(
			'id' => 'top_bar',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Top Bar', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'top_bar_fullwidth',
			'default' => false,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Full Width', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'main_layout_style',
				'value' => 'boxed',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'top_bar_sticky',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Sticky on Scroll', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'top_bar_sticky_mobile',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Sticky on Mobile', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'top_bar_sticky',
				'value' => 'true',
			),
		),
		array(
			'id' => 'top_bar_bottom_border',
			'default' => true,
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Bottom Border', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'top_bar_visibility',
			'control' => array(
				'label' => esc_html__( 'Visibility', 'total' ),
				'type' => 'wpex-visibility-select',
			),
		),
		array(
			'id' => 'top_bar_style',
			'default' => 'one',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Layout', 'total' ),
				'type' => 'select',
				'choices' => array(
					'one' => esc_html__( 'Default', 'total' ),
					'two' => esc_html__( 'Reverse', 'total' ),
					'three' => esc_html__( 'Centered', 'total' ),
				),
			),
		),
		array(
			'id' => 'topbar_split_breakpoint',
			'transport' => 'refresh',
			'control' => array(
				'label' => esc_html__( 'Responsive Breakpoint', 'total' ),
				'type' => 'select',
				'choices' => $breakpoints,
				'description' => esc_html__( 'Select the breakpoint at which point the top bar is split into a left/right layout.' ),
			),
		),
		array(
			'id' => 'topbar_alignment',
			'transport' => 'refresh',
			'control' => array(
				'label' => esc_html__( 'Collapsed Alignment', 'total' ),
				'type' => 'select',
				'choices' => array(
					''       => esc_html__( 'Default', 'total' ),
					'left'   => esc_html__( 'Left', 'total' ),
					'center' => esc_html__( 'Center', 'total' ),
					'right'  => esc_html__( 'Right', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'topbar_split_breakpoint',
				'value' => 'none',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'top_bar_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'inline_css' => array(
				'target' => array(
					'#top-bar-wrap',
					'.wpex-top-bar-sticky',
				),
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'top_bar_border',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Borders', 'total' ),
			),
			'inline_css' => array(
				'target' => '#top-bar-wrap',
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'top_bar_text',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#top-bar',
				'alter' => 'color',
			),
		),
		// link colors
		array(
			'id' => 'top_bar_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#top-bar',
				'alter' => '--wpex-link-color',
			),
		),
		array(
			'id' => 'top_bar_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => '#top-bar',
				'alter' => '--wpex-hover-link-color',
			),
		),
		// Padding
		array(
			'id' => 'top_bar_top_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Top Padding', 'total' ),
				'placeholder' => '15',
			),
			'inline_css' => array(
				'target' => '#top-bar',
				'alter' => 'padding-top',
				'sanitize' => 'padding',
			),
		),
		array(
			'id' => 'top_bar_bottom_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Bottom Padding', 'total' ) ,
				'placeholder' => '15',
			),
			'inline_css' => array(
				'target' => '#top-bar',
				'alter' => 'padding-bottom',
				'sanitize' => 'padding',
			),
		),
	),
);

/*-----------------------------------------------------------------------------------*/
/* - TopBar => Content
/*-----------------------------------------------------------------------------------*/
$this->sections['wpex_topbar_content'] = array(
	'title' => esc_html__( 'Content', 'total' ),
	'panel' => 'wpex_topbar',
	'settings' => array(
		array(
			'id' => 'top_bar_content',
			'transport' => 'partialRefresh',
			'default' => TotalTheme\Topbar\Core::get_default_content(),
			'control' => array(
				'label' => esc_html__( 'Content', 'total' ),
				'type' => 'wpex_textarea',
				'rows' => 20,
				'description' => esc_html__( 'HTML and shortcodes allowed.', 'total' ),
			),
		),
		array(
			'id' => 'topbar_item_breakpoint',
			'transport' => 'refresh',
			'control' => array(
				'label' => esc_html__( 'Top Bar Item Responsive Breakpoint', 'total' ),
				'type' => 'select',
				'choices' => $breakpoints,
				'description' => esc_html__( 'By default the [topbar_item] shortcode elements stack at 640px but you can change their default stacking breakpoint.' ),
			),
			'control_display' => array(
				'check' => 'topbar_split_breakpoint',
				'value' => 'none',
				'compare' => 'not_equal',
			),
		),
	),
);

/*-----------------------------------------------------------------------------------*/
/* - TopBar => Social
/*-----------------------------------------------------------------------------------*/
$this->sections['wpex_topbar_social'] = array(
	'title' => esc_html__( 'Social', 'total' ),
	'panel' => 'wpex_topbar',
	'settings' => array(
		array(
			'id' => 'top_bar_social_alt',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Social Alternative', 'total' ),
				'type' => 'textarea',
				'description' => esc_html__( 'HTML and shortcodes allowed.', 'total' ),
			),
		),
		array(
			'id' => 'top_bar_social',
			'default' => true,
			'transport' => 'refresh', // Other items relly on this conditionally to show/hide
			'control' => array(
				'label' => esc_html__( 'Display Social', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Display social links if the "Social Alternative" field above is empty.', 'total' ),
			),
		),
		array(
			'id' => 'top_bar_social_target',
			'default' => 'blank',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Social Link Target', 'total' ),
				'type' => 'select',
				'choices' => array(
					'blank' => esc_html__( 'New Window', 'total' ),
					'self' => esc_html__( 'Same Window', 'total' ),
				),
			),
		),
		array(
			'id' => 'top_bar_social_style',
			'default' => 'default',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Social Style', 'total' ),
				'type' => 'select',
				'choices' => 'social_styles',
			),
		),
		array(
			'id' => 'top_bar_social_gap',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Spacing Between Social Links', 'total' ),
				'type'  => 'select',
				'choices' => 'margin',
			),
		),
		array(
			'id' => 'top_bar_social_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Social Links Font Size', 'total' ),
				'placeholder' => '14',
			),
			'inline_css' => array(
				'target' => '#top-bar-social a.wpex-social-btn',
				'alter' => 'font-size',
				'sanitize' => 'font-size',
			),
		),
		array(
			'id' => 'top_bar_social_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Social Links Color', 'total' ),
				'description' => esc_html__( 'Applied only when the social style is set to "none".', 'total' ),
			),
			'inline_css' => array(
				'target' => '#top-bar-social a.wpex-social-btn-no-style',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'top_bar_social_hover_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Social Links Hover Color', 'total' ),
				'description' => esc_html__( 'Applied only when the social style is set to "none".', 'total' ),
			),
			'inline_css' => array(
				'target' => '#top-bar-social a.wpex-social-btn-no-style:hover',
				'alter' => 'color',
			),
		),
	),
);

// Social settings.
if ( TotalTheme\Topbar\Social::get_profile_options() && $this->is_customize_preview() ) {
	$this->sections['wpex_topbar_social']['settings'][] = array(
		'id' => 'wpex_topbar_social_heading',
		'control' => array(
			'type' => 'wpex-heading',
			'label' => esc_html__( 'Social Profiles', 'total' ),
		),
	);
	$this->sections['wpex_topbar_social']['settings'][] = array(
		'id' => 'top_bar_social_profiles',
		'transport' => 'postMessage',
		'control' => array(
			'type' => 'wpex_social_profiles',
		),
	);
}