<?php
defined( 'ABSPATH' ) || exit;

// Archives
$this->sections['wpex_staff_archives'] = array(
	'title' => esc_html__( 'Archives', 'total' ),
	'panel' => 'wpex_staff',
	'description' => esc_html__( 'The following options are for the post type category and tag archives.', 'total' ),
	'settings' => array(
		array(
			'id' => 'staff_archive_has_page_header',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_has_page_header',
			),
		),
		array(
			'id' => 'staff_archive_layout',
			'default' => 'full-width',
			'control' => array(
				'label' => esc_html__( 'Page Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'staff_pagination_style',
			'control' => array(
				'label' => esc_html__( 'Pagination Style', 'total' ),
				'type' => 'select',
				'choices' => 'TotalTheme\\Pagination\\Core::choices',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_archive_template_id',
			'control' => array(
				'label' => esc_html__( 'Dynamic Template', 'total' ),
				'type' => 'wpex-dropdown-templates',
				'description' => esc_html__( 'Select a template to override the default output for the post type archive, category and tag entries.', 'total' ),
			),
		),
		array(
			'id' => 'staff_entry_card_style',
			'control' => array(
				'label' => esc_html__( 'Card Style', 'total' ),
				'type' => 'wpex-card-select',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_archive_grid_style',
			'default' => 'fit-rows',
			'control' => array(
				'label' => esc_html__( 'Grid Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'fit-rows' => esc_html__( 'Fit Rows','total' ),
					'masonry' => esc_html__( 'Masonry','total' ),
					'no-margins' => esc_html__( 'No Margins','total' ),
				),
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_entry_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Columns', 'total' ),
				'type' => 'wpex-columns',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_archive_grid_gap',
			'control' => array(
				'label' => esc_html__( 'Gap', 'total' ),
				'type' => 'select',
				'choices' => 'column_gap',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_archive_posts_per_page',
			'default' => '12',
			'control' => array(
				'label' => esc_html__( 'Posts Per Page', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'staff_entry_overlay_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Image Overlay', 'total' ),
				'type' => 'select',
				'choices' => 'overlay',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_entry_image_hover_animation',
			'control' => array(
				'label' => esc_html__( 'Image Hover Animation', 'total' ),
				'type' => 'select',
				'choices' => wpex_image_hovers(),
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_archive_grid_equal_heights',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Equal Heights', 'total' ),
				'description' => esc_html__( 'If enabled it will set the content of each entry so they are the same height.', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_staff_supports_equal_heights',
			),
		),
		array(
			'id' => 'staff_entry_details',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Entry Details', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_staff_card',
			),
		),
		array(
			'id' => 'staff_entry_position',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Company Position', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_staff_card',
			),
		),
		array(
			'id' => 'staff_entry_excerpt_length',
			'default' => '20',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter 0 or leave blank to disable, enter -1 to display the full post content.', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'staff_entry_social',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Social Links', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_staff_card',
			),
		),
	),
);

// Single
$this->sections['wpex_staff_single'] = array(
	'title' => esc_html__( 'Single Post', 'total' ),
	'panel' => 'wpex_staff',
	'settings' => array(
		array(
			'id' => 'staff_singular_page_title',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_has_page_header',
			),
		),
		array(
			'id' => 'staff_next_prev',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Next & Previous Links', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'staff_single_header_position',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Company Position', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to display the staff member company position in the page header title subheading region.', 'total' ),
			),
		),
		array(
			'id' => 'staff_single_layout',
			'control' => array(
				'label' => esc_html__( 'Page Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'staff_single_header',
			'default' => 'post_type_name',
			'control' => array(
				'label' => esc_html__( 'Page Header Title Displays', 'total' ),
				'type' => 'select',
				'choices' => array(
					'post_type_name' => esc_html__( 'Post Type Name','total' ),
					'post_title' => esc_html__( 'Post Title','total' ),
					'first_category' => esc_html__( 'First Category','total' ),
				),
			),
			'control_display' => array(
				'check' => 'staff_singular_page_title',
				'value' => 'true',
			),
		),
		array(
			'id' => 'staff_singular_template',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Dynamic Template', 'total' ),
				'type' => 'wpex-dropdown-templates',
			),
		),
		array(
			'id' => 'staff_post_composer',
			'default' => 'content,related',
			'control' => array(
				'label' => esc_html__( 'Post Layout Elements', 'total' ),
				'type' => 'wpex_blocks',
				'choices' => 'TotalTheme\\Staff\\Single_Blocks::choices',
				'description' => esc_html__( 'Used when displaying the default (non-dynamic) post template.', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_singular_template',
			),
		),
	),
);

// Related
$this->sections['wpex_staff_single_related'] = array(
	'title' => esc_html__( 'Related Posts', 'total' ),
	'panel' => 'wpex_staff',
	'description' => esc_html__( 'The related posts section displays at the bottom of the post content and can be enabled/disabled via the Post Layout Elements setting under the "Single Post" tab.', 'total' ),
	'settings' => array(
		array(
			'id' => 'staff_related_title',
			'default' => esc_html__( 'Related Staff', 'total' ),
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Related Posts Title', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'staff_related_entry_card_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Card Style', 'total' ),
				'type' => 'wpex-card-select',
			),
		),
		array(
			'id' => 'staff_related_count',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Post Count', 'total' ),
				'type' => 'text',
			),
		),
		array(
			'id' => 'staff_related_taxonomy',
			'default' => taxonomy_exists( 'staff_category' ) ? 'staff_category' : 'none',
			'control' => array(
				'label' => esc_html__( 'Related By', 'total' ),
				'type' => 'select',
				'choices' => 'staff_taxonomies',
			),
		),
		array(
			'id' => 'staff_related_order',
			'default' => 'description',
			'control' => array(
				'label' => esc_html__( 'Order', 'total' ),
				'type' => 'select',
				'choices' => array(
					'description' => esc_html__( 'DESC', 'total' ),
					'asc' => esc_html__( 'ASC', 'total' ),
				),
			),
		),
		array(
			'id' => 'staff_related_orderby',
			'default' => 'date',
			'control' => array(
				'label' => esc_html__( 'Order By', 'total' ),
				'type' => 'select',
				'choices' => array(
					'date'          => esc_html__( 'Date', 'total' ),
					'title'         => esc_html__( 'Title', 'total' ),
					'modified'      => esc_html__( 'Modified', 'total' ),
					'author'        => esc_html__( 'Author', 'total' ),
					'rand'          => esc_html__( 'Random', 'total' ),
					'comment_count' => esc_html__( 'Comment Count', 'total' ),
				),
			),
		),
		array(
			'id' => 'staff_related_columns',
			'default' => '3',
			'control' => array(
				'label' => esc_html__( 'Columns', 'total' ),
				'type' => 'wpex-columns',
			),
		),
		array(
			'id' => 'staff_related_gap',
			'control' => array(
				'label' => esc_html__( 'Gap', 'total' ),
				'type' => 'select',
				'choices' => 'column_gap',
			),
		),
		array(
			'id' => 'staff_related_entry_overlay_style',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Image Overlay', 'total' ),
				'type' => 'select',
				'choices' => 'overlay'
			),
		),
		array(
			'id' => 'staff_related_excerpts',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Entry Details', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_staff_related_card',
			),
		),
		array(
			'id' => 'staff_related_entry_excerpt_length',
			'default' => '20',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter 0 or leave blank to disable, enter -1 to display the full post content.', 'total' ),
			),
		),
	)
);

// Social Links
$this->sections['wpex_staff_social_links'] = array(
	'title' => esc_html__( 'Social Links', 'total' ),
	'panel' => 'wpex_staff',
	'settings' => array(
		array(
			'id' => 'staff_social_show_icons',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Icons', 'total' ),
				'description' => esc_html__( 'If disabled it will display text links.', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'staff_social_default_style',
			'default' => 'minimal-round',
			'control' => array(
				'label' => esc_html__( 'Default Social Style', 'total' ),
				'type' => 'select',
				'choices' => 'social_styles',
			),
			'control_display' => array(
				'check' => 'staff_social_show_icons',
				'value' => 'true',
			),
		),
		array(
			'id' => 'staff_social_link_target',
			'default' => 'blank',
			'control' => array(
				'label' => esc_html__( 'Link Target', 'total' ),
				'type' => 'select',
				'choices' => array(
					'blank' => esc_html__( 'Blank', 'total' ),
					'self' => esc_html__( 'Self', 'total' ),
				),
			),
		),
		array(
			'id' => 'staff_social_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'allow_numeric' => false,
				'label' => esc_html__( 'Icon Size', 'total' ),
			),
			'inline_css' => array(
				'target' => '.staff-social',
				'alter' => 'font-size',
			),
		),
	)
);