<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_mobile_menu'] = array(
	'title' => esc_html__( 'Mobile Menu', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'mobile_menu_search',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Search Box', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'mobile_menu_breakpoint',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Breakpoint', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'description' => esc_html__( 'Enter a custom viewport width in pixels for when the default menu will become the mobile menu. Enter 9999 to display the mobile menu always.', 'total' ),
				'placeholder' => '959',
			),
		),
		array(
			'id' => 'mobile_menu_style',
			'default' => 'sidr',
			'control' => array(
				'label' => esc_html__( 'Mobile Menu Style', 'total' ),
				'type' => 'select',
				'choices' => wpex_get_mobile_menu_styles(),
			),
		),
		array(
			'id' => 'mobile_menu_toggle_style',
			'default' => 'icon_buttons',
			'control' => array(
				'label' => esc_html__( 'Toggle Button Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'icon_buttons' => esc_html__( 'Side Hamburger Icon', 'total' ),
					'icon_buttons_under_logo' => esc_html__( 'Centered Hamburger Icon', 'total' ),
					'centered_logo' => esc_html__( 'Centered Logo (Flex Header Styles only)', 'total' ),
					'next_to_logo' => esc_html__( 'Hamburger Icon Next to Logo (Flex Header Styles only)', 'total' ),
					'navbar' => esc_html__( 'Navbar', 'total' ),
					'fixed_top' => esc_html__( 'Fixed Top Navbar', 'total' ),
					'custom'  => esc_html__( 'Custom', 'total' ),
				),
				'description' => esc_html__( 'If you select "custom" the theme will load the needed code for your mobile menu which you can then open/close by adding any link to the page with the classname "mobile-menu-toggle".', 'total' )
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'disabled',
				'compare' => 'not_equal',
			),
		),
		/*** Mobile Menu > Toggle Settings ***/
		array(
			'id' => 'mobile_toggle_styling',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Toggle Styling', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_toggle_style',
				'value' => array( 'navbar', 'fixed_top' ),
			),
		),
		array(
			'id' => 'mobile_menu_navbar_position',
			'default' => 'wpex_hook_header_bottom',
			'control' => array(
				'label' => esc_html__( 'Toggle Button Position', 'total' ),
				'type' => 'select',
				'choices' => array(
					'wpex_hook_header_bottom' => esc_html__( 'Header Bottom', 'total' ),
					'outer_wrap_before' => esc_html__( 'Top of site', 'total' ),
				),
				'description' => esc_html__( 'note: will always display at the top of the site when the Transparent Header is enabled.', 'total' )
			),
			'control_display' => array(
				'check' => 'mobile_menu_toggle_style',
				'value' => 'navbar',
			),
		),
		array(
			'id' => 'mobile_menu_toggle_fixed_top_bg',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Toggle Background', 'total' ),
				'type' => 'color',
			),
			'control_display' => array(
				'check' => 'mobile_menu_toggle_style',
				'value' => array( 'navbar', 'fixed_top' ),
			),
			'inline_css' => array(
				'target' => '#wpex-mobile-menu-fixed-top, #wpex-mobile-menu-navbar',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'mobile_menu_toggle_text',
			'control' => array(
				'label' => esc_html__( 'Toggle Text', 'total' ),
				'type' => 'text',
				'input_attrs' => array(
					'placeholder' => esc_html__( 'Menu', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'mobile_menu_toggle_style',
				'value' => array( 'navbar', 'fixed_top' ),
			),
		),
		array(
			'id' => 'mobile_menu_toggle_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'text',
				'label' => esc_html__( 'Toggle Font Size', 'total' ),
				'input_attrs' => array(
					'placeholder' => '1em',
				),
			),
			'control_display' => array(
				'check' => 'mobile_menu_toggle_style',
				'value' => array( 'navbar', 'fixed_top' ),
			),
			'inline_css' => array(
				'target' => '#wpex-mobile-menu-navbar,#wpex-mobile-menu-fixed-top',
				'alter' => 'font-size',
				'sanitize' => 'font-size',
			),
		),
		array(
			'id' => 'mobile_menu_toggle_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_pixel',
				'label' => esc_html__( 'Toggle Height', 'total' ),
				'input_attrs' => array(
					'placeholder' => '50',
				),
			),
			'control_display' => array(
				'check' => 'mobile_menu_toggle_style',
				'value' => array( 'navbar', 'fixed_top' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-mobile-menu-toggle-height',
				'sanitize' => 'px',
			),
		),
		/*** Mobile Menu > Mobile Icons Styling ***/
		array(
			'id' => 'mobile_menu_icons_styling',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Icons Styling', 'total' ),
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
			),
		),
		array(
			'id' => 'mobile_menu_icon_toggle_state',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Hamburger Icon Active State', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'When enabled the hamburger icon will turn into an "x" while active.', 'total' ),
				'active_callback' => 'wpex_cac_mobile_menu_hamburger_supports_active_state',
			),
		),
		array(
			'id' => 'mobile_menu_icon_animate',
			'transport' => 'postMessage',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Hamburger Icon Animation', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Animates the active state transition.', 'total' ),
				'active_callback' => 'wpex_cac_mobile_menu_hamburger_supports_animation',
			),
		),
		array(
			'id' => 'mobile_menu_icon_rounded',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Hamburger Icon Rounded Edges', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
			),
		),
		array(
			'id' => 'mobile_menu_icon_side_margin',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Hamburger Icon Side Margin', 'total' ),
				'type' => 'wpex_pixel',
				'description' => esc_html__( 'Adds a space between the hamburger icon and the content beside it.', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'eight', 'nine' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-mobile-menu-toggle-side-margin',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'mobile_menu_icon_label',
			'control' => array(
				'label' => esc_html__( 'Hamburger Icon Label', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Adds custom text next to your hamburger menu icon.', 'total' ),
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
			),
		),
		array(
			'id' => 'mobile_menu_icon_label_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Hamburger Icon Label Font Size', 'total' ),
				'type' => 'text',
				'active_callback' => 'wpex_cac_mobile_menu_hamburger_has_label',
			),
			'inline_css' => array(
				'target' => '.mobile-menu-toggle__label',
				'alter' => 'font-size',
				'sanitize' => 'font-size',
			),
		),
		array(
			'id' => 'mobile_menu_icon_label_position',
			'control' => array(
				'label' => esc_html__( 'Hamburger Icon Label Position', 'total' ),
				'default' => 'right',
				'type' => 'select',
				'active_callback' => 'wpex_cac_mobile_menu_hamburger_has_label',
				'choices' => array(
					'right' => esc_html__( 'Right', 'total' ),
					'left' => esc_html__( 'Left', 'total' ),
				),
			),
		),
		array(
			'id' => 'mobile_menu_icon_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Hamburger Icon Width', 'total' ),
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
				'placeholder' => '22',
			),
			'inline_css' => array(
				'target' => '.mobile-menu-toggle',
				'alter' => '--wpex-hamburger-icon-width',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'mobile_menu_icon_item_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Hamburger Icon Bar Height', 'total' ),
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
				'description' => esc_html__( 'Alters the height of each bar of the hamburger icon.', 'total' ),
				'placeholder' => '3',
			),
			'inline_css' => array(
				'target' => '.mobile-menu-toggle',
				'alter' => '--wpex-hamburger-icon-bar-height',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'mobile_menu_icon_gutter',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Hamburger Icon Gutter', 'total' ),
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
				'description' => esc_html__( 'Alters the space between each bar of the hamburger icon.', 'total' ),
				'placeholder' => '4',
			),
			'inline_css' => array(
				'target' => '.mobile-menu-toggle',
				'alter' => '--wpex-hamburger-icon-gutter',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'mobile_menu_icon_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
			),
			'inline_css' => array(
				'target' => '#mobile-menu',
				'alter' => array(
					'--wpex-link-color',
					'--wpex-hover-link-color',
				),
			),
		),
		array(
			'id' => 'mobile_menu_icon_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color: Hover', 'total' ),
				'active_callback' => 'wpex_cac_has_mobile_menu_icons',
			),
			'inline_css' => array(
				'target' => '#mobile-menu',
				'alter' => '--wpex-hover-link-color',
			),
		),

		/*** Mobile Menu > Full-Screen ***/
		array(
			'id' => 'mobile_menu_full_screen_styling',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Full-Screen Menu Styling', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'full_screen',
			),
		),
		array(
			'id' => 'mobile_menu_full_screen_under_header',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Display Under The Header', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'full_screen',
			),
		),
		array(
			'id' => 'full_screen_mobile_menu_style',
			'default' => 'white',
			'control' => array(
				'label' => esc_html__( 'Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'white'	=> esc_html__( 'White', 'total' ),
					'black'	=> esc_html__( 'Black', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'full_screen',
			),
		),
		array(
			'id' => 'mobile_menu_full_screen_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'full_screen',
			),
			'inline_css' => array(
				'target' => '.full-screen-overlay-nav',
				'alter' => 'background-color',
				'important' => true,
			),
		),
		array(
			'id' => 'mobile_menu_full_screen_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'full_screen',
			),
			'inline_css' => array(
				'target' => '.full-screen-overlay-nav',
				'alter' => 'color',
				'important' => true,
			),
		),

		/*** Mobile Menu > Sidr ***/
		array(
			'id' => 'mobile_menu_sidr_styling',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Sidebar Menu Styling', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_dark_surface',
			'transport' => 'postMessage',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Dark Surface', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Adds dark styling to the element, disable to use default color scheme.', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_displace',
			'control' => array(
				'label' => esc_html__( 'Site Displacement', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to display/push the site content over when opening the sidebar mobile menu.', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Width', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px', '%', 'vw', 'func' ),
				'placeholder' => '320',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-sidr-width',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_direction',
			'control' => array(
				'label' => esc_html__( 'Open Direction', 'total' ),
				'type' => 'select',
				'choices' => array(
					''	=> esc_html__( 'Default', 'total' ),
					'right'	=> esc_html__( 'From Right', 'total' ),
					'left'	=> esc_html__( 'From Left', 'total' ),
				),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_gutter',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Gutter', 'total' ),
				'description' => esc_html__( 'Adds padding around the mobile menu content.', 'total' ),
				'placeholder' => '0px',
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-sidr-gutter',
				'sanitize' => 'margin',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_close_align',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Close Icon Align', 'total' ),
				'type' => 'select',
				'choices' => array(
					''	=> esc_html__( 'Default', 'total' ),
					'right'	=> esc_html__( 'Right', 'total' ),
					'left'	=> esc_html__( 'Left', 'total' ),
				),
			),
			'inline_css' => array(
				'target' => '.sidr-class-wpex-close',
				'alter' => 'text-align',
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
			'inline_css' => array(
				'target' => '#sidr-main,.sidr-class-dropdown-menu ul',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 'mobile_menu_sidr_borders',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Borders', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
			'inline_css' => array(
				'target' => '#sidr-main',
				'alter' => '--wpex-border-main',
			),
		),
		array(
			'id' => 'mobile_menu_links',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
			'inline_css' => array(
				'target' => '#sidr-main',
				'alter' => array(
					'color', // legacy from 5.4 !!important!!!
					'--wpex-text-2', // targets elements inside the dark-surface
					'--wpex-link-color', // !! don't target hover color !!!
				),
			),
		),
		array(
			'id' => 'mobile_menu_links_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Links: Hover', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'sidr',
			),
			'inline_css' => array(
				'target' => '#sidr-main',
				'alter' => '--wpex-hover-link-color',
			),
		),
		/*** Mobile Menu > Toggle Menu ***/
		array(
			'id' => 'mobile_menu_toggle_styling',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Dropdown Menu Styling', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
		),
		array(
			'id' => 'mobile_menu_toggle_animate',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Dropdown Animation', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
		),
		array(
			'id' => 'mobile_menu_toggle_has_border_top',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Top Border', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
		),
		array(
			'id' => 'mobile_menu_toggle_has_border_bottom',
			'default' => false,
			'control' => array(
				'label' => esc_html__( 'Bottom Border', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
		),
		array(
			'id' => 'toggle_mobile_menu_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
			'inline_css' => array(
				'target' => '.mobile-toggle-nav',
				'alter' => 'background',
			),
		),
		array(
			'id' => 'toggle_mobile_menu_borders',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Borders', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
			'inline_css' => array(
				'target' => '.mobile-toggle-nav-ul,.mobile-toggle-nav-ul a',
				'alter' => 'border-color',
			),
		),
		array(
			'id' => 'toggle_mobile_menu_links',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Color', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
			'inline_css' => array(
				'target' => '.mobile-toggle-nav',
				'alter' => array(
					'color',
					'--wpex-link-color',
				),
			),
		),
		array(
			'id' => 'toggle_mobile_menu_links_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Links: Hover', 'total' ),
			),
			'control_display' => array(
				'check' => 'mobile_menu_style',
				'value' => 'toggle',
			),
			'inline_css' => array(
				'target' => '.mobile-toggle-nav',
				'alter' => '--wpex-hover-link-color',
			),
		),
		// Mobile menu link padding.
		array(
			'id' => 'mobile_menu_links_padding_y',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Links: Vertical Padding', 'total' ),
				'placeholder' => '10',
			),
			'inline_css' => array(
				'target' => '.full-screen-overlay-nav-menu__link,.mobile-toggle-nav__link,.sidr-mobile-nav-menu__link',
				'alter' => [ 'padding-top', 'padding-bottom' ],
				'sanitize' => 'padding',
			),
		),
	),
);