<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_menu'] = array(
	'title' => esc_html__( 'Menu', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'header_menu_disable_outline',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Disable Outline', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'two', 'three', 'four' ),
			),
		),
		array(
			'id' => 'header_menu_disable_borders',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Disable Inner Borders', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'two', 'six' ),
			),
		),
		array(
			'id' => 'header_menu_center',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Center Menu Items', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'two',
			),
		),
		array(
			'id' => 'header_menu_stretch_items',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Fill Space', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to make your menu items fill up the available navigation area.', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'two', 'three', 'four', 'five' ),
			),
		),
		array(
			'id' => 'menu_flush_dropdowns',
			'control' => array(
				'label' => esc_html__( 'Full-Height', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'When enabled your menu li elements will display at the same height as your header so that your dropdowns line up with the bottom of the header.', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'one', 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'header_menu_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Custom Menu Height', 'total' ),
				'placeholder' => '50',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-main-nav-height',
					'--wpex-main-nav-line-height',
				),
				'sanitize' => 'px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'one', 'two', 'three', 'four', 'five' ),
			),
		),
		array(
			'id' => 'main_nav_gutter',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Gutter', 'total' ),
				'description' => esc_html__( 'Applies a left margin to the top level menu items.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap', // must target this to override certain things.
				'alter' => '--wpex-main-nav-gutter',
				'sanitize' => 'fallback_px',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'one', 'two', 'three', 'four', 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'main_nav_link_padding_y',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Menu Item Vertical Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => '.navbar-style-seven,.navbar-style-eight,.navbar-style-nine,.navbar-style-ten',
				'alter' => '--wpex-main-nav-link-padding-y',
				'sanitize' => 'padding',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'seven', 'eight', 'nine', 'ten' ),
			),
		),
		array(
			'id' => 'main_nav_link_padding_x',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'exclude_units' => array( '%' ),
				'label' => esc_html__( 'Menu Item Horizontal Padding', 'total' ),
				'description' => esc_html__( 'Applies a left and right padding to the top level menu items.', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap', // must target this to override certain things.
				'alter' => '--wpex-main-nav-link-padding-x',
				'sanitize' => 'padding',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		/*** Active Item ***/
		array(
			'id' => 'menu_active_underline',
			//'transport' => 'postMessage', // can't
			'control' => array(
				'label' => esc_html__( 'Hover & Active Underline', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_menu_supports_active_underline', // can't use control display, cause the next setting needs to check for this one via active_callback.
			),
		),
		array(
			'id' => 'menu_active_underline_height',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'placeholder' => '3',
				'label' => esc_html__( 'Underline Size', 'total' ),
				'active_callback' => 'wpex_cac_menu_has_active_underline',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-main-nav-link-underline-height',
				'sanitize' => 'px',
			),
		),
		array(
			'id' => 'menu_active_underline_speed',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'select',
				'label' => esc_html__( 'Underline Animation Speed', 'total' ),
				'active_callback' => 'wpex_cac_menu_has_active_underline',
				'choices' => array(
					''       => esc_html__( 'Default', 'total' ),
					'0s'     => '0ms',
					'75ms'   => '75ms',
					'100ms'  => '100ms',
					'150ms'  => '150ms',
					'200ms'  => '200ms',
					'300ms'  => '300ms',
					'500ms'  => '500ms',
					'700ms'  => '700ms',
					'1000ms' => '1000ms',
				),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-main-nav-link-underline-transition-duration',
			),
		),
		array(
			'id' => 'menu_active_underline_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Underline Color', 'total' ),
				'active_callback' => 'wpex_cac_menu_has_active_underline',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-main-nav-link-underline-color',
			),
		),
		array(
			'id' => 'menu_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background', 'total' ),
				'description' => esc_html__( 'Not applied to the transparent header.', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-main-nav-bg',
			),
		),
		array(
			'id' => 'menu_borders',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Borders', 'total' ),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'two', 'three', 'four', 'six' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-main-nav-border-color',
			),
		),
		// Menu Link Colors
		array(
			'id' => 'menu_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array(
					'--wpex-main-nav-link-color',
					'--wpex-hover-main-nav-link-color',
					'--wpex-active-main-nav-link-color',
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'menu_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-hover-main-nav-link-color',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'menu_link_color_active',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Current Menu Item', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-active-main-nav-link-color',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		// Link Background
		array(
			'id' => 'menu_link_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Background', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => array(
					'--wpex-main-nav-link-bg',
					'--wpex-hover-main-nav-link-bg',
					'--wpex-active-main-nav-link-bg',
				)
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'menu_link_hover_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Background: Hover', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-hover-main-nav-link-bg',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		array(
			'id' => 'menu_link_active_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Background: Current Menu Item', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-navigation-wrap',
				'alter' => '--wpex-active-main-nav-link-bg',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => 'dev',
				'compare' => 'not_equal',
			),
		),
		// Link Inner
		array(
			'id' => 'menu_link_span_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Inner Background', 'total' ),
			),
			'inline_css' => array(
				// @todo add new class "navbar-supports-inner-bg" and target this.
				'target' => '.navbar-style-one,.navbar-style-two,.navbar-style-three,.navbar-style-four,.navbar-style-five,.navbar-style-six',
				'alter' => array(
					'--wpex-main-nav-link-inner-bg',
					'--wpex-hover-main-nav-link-inner-bg',
					'--wpex-active-main-nav-link-inner-bg'
				),
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'one', 'two', 'three', 'four', 'five', 'six' ),
			),
		),
		array(
			'id' => 'menu_link_span_hover_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Inner Background: Hover', 'total' ),
			),
			'inline_css' => array(
				// @todo add new class "navbar-supports-inner-bg" and target this.
				'target' => '.navbar-style-one,.navbar-style-two,.navbar-style-three,.navbar-style-four,.navbar-style-five,.navbar-style-six',
				'alter' => '--wpex-hover-main-nav-link-inner-bg',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'one', 'two', 'three', 'four', 'five', 'six' ),
			),
		),
		array(
			'id' => 'menu_link_span_active_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Inner Background: Current Menu Item', 'total' ),
			),
			'inline_css' => array(
				// @todo add new class "navbar-supports-inner-bg" and target this.
				'target' => '.navbar-style-one,.navbar-style-two,.navbar-style-three,.navbar-style-four,.navbar-style-five,.navbar-style-six',
				'alter' => '--wpex-active-main-nav-link-inner-bg',
			),
			'control_display' => array(
				'check' => 'header_style',
				'value' => array( 'one', 'two', 'three', 'four', 'five', 'six' ),
			),
		),
	),
);