<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_header_logo_icon'] = array(
	'title' => esc_html__( 'Logo Icon', 'total' ),
	'description' => esc_html__( 'The logo icon is used only when displaying a text based logo.', 'total' ),
	'panel' => 'wpex_header',
	'settings' => array(
		array(
			'id' => 'logo_icon',
			'default' => 'none',
			'control' => array(
				'label' => esc_html__( 'Icon', 'total' ),
				'type' => 'wpex_ticon_select',
			),
			'control_display' => array(
				'check' => 'logo_icon_img',
				'value' => 'false',
			),
		),
		array(
			'id' => 'logo_icon_img',
			'control' => array(
				'label' => esc_html__( 'Custom Icon', 'total' ),
				'type' => 'media',
				'mime_type' => 'image',
				'description' => esc_html__( 'Choose a custom icon to use instead of a theme font icon. An SVG image would be recommended.', 'total' ),
			),
		),
		array(
			'id' => 'logo_icon_img_dims',
			'control' => array(
				'label' => esc_html__( 'Icon Width', 'total' ),
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'description' => esc_html__( 'Required for SVG images.', 'total' ),
			),
			'control_display' => array(
				'check' => 'logo_icon_img',
				'value' => 'true',
			),
		),
		array(
			'id' => 'logo_icon_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Logo Icon Color', 'total' ),
			),
			'inline_css' => array(
				'target' => '#site-logo-fa-icon',
				'alter' => 'color',
			),
			'control_display' => array(
				'check' => 'logo_icon_img',
				'value' => 'false',
			),
		),
		array(
			'id' => 'logo_icon_right_margin',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'label' => esc_html__( 'Logo Icon Right Margin', 'total' ),
				'sanitize_callback' => 'sanitize_text_field',
				'placeholder' => '10',
			),
			'inline_css' => array(
				'target' => '#site-logo-fa-icon, #site-logo-icon',
				'alter' => is_rtl() ? 'margin-left' : 'margin-right',
				'sanitize' => 'margin',
			),
		),
	)
);