<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_forms'] = array(
	'title' => esc_html__( 'Forms', 'total' ),
	'panel' => 'wpex_global_styles',
	'settings' => array(
		array(
			'id' => 'label_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Label Color', 'total' ),
			),
			'inline_css' => array(
				'target' => 'label',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'input_padding',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_trbl',
				'shorthand' => true,
				'label' => esc_html__( 'Input Padding', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-input-padding',
			),
		),
		array(
			'id' => 'input_border_radius',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px', 'em', 'rem', '%', 'var' ),
				'label' => esc_html__( 'Input Border Radius', 'total' ),
				'placeholder' => '3',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-input-border-radius',
			),
		),
		array(
			'id' => 'input_font_size',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'default_unit' => 'em',
				'label' => esc_html__( 'Input Font-Size', 'total' ),
				'placeholder' => '1',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-input-font-size',
			),
		),
		array(
			'id' => 'input_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Input Color', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-input-color',
					'--wpex-focus-input-color',
				),
			),
		),
		array(
			'id' => 'input_background',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Input Background', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-input-bg',
					'--wpex-focus-input-bg',
				),
			),
		),
		array(
			'id' => 'input_border',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Input Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-input-border-color',
					'--wpex-focus-input-border-color',
				),
			),
		),
		array(
			'id' => 'input_border_width',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'wpex_length_unit',
				'units' => array( 'px' ),
				'label' => esc_html__( 'Input Border Width', 'total' ),
				'placeholder' => '1',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-input-border-width',
			),
		),
		array(
			'id' => 'input_color_focus',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Input Focus: Color', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-focus-input-color',
			),
		),
		array(
			'id' => 'input_background_focus',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Input Focus: Background', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-focus-input-bg',
			),
		),
		array(
			'id' => 'input_border_focus',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Input Focus: Border Color', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-focus-input-border-color',
			),
		),
	),
);