<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_accent_colors'] = array(
	'title' => esc_html__( 'Accent Colors', 'total' ),
	'panel' => 'wpex_global_styles',
	'settings' => array(
		array(
			'id' => 'accent_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Accent', 'total' ),
				'type' => 'color',
				'description' => esc_html__( 'Main accent color used for buttons, links, active elements, etc.', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-accent',
					'--wpex-accent-alt',
				),
			),
		),
		array(
			'id' => 'accent_on_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'On Accent', 'total' ),
				'type' => 'color',
				'description' => esc_html__( 'Text color for elements with an accent background.', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => array(
					'--wpex-on-accent',
					'--wpex-on-accent-alt',
				),
			),
		),
		array(
			'id' => 'accent_color_hover',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Accent Alt', 'total' ),
				'description' => esc_html__( 'Default hover background color for buttons or an alternative accent color.', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-accent-alt',
			),
		),
		array(
			'id' => 'accent_on_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'On Accent Alt', 'total' ),
				'type' => 'color',
				'description' => esc_html__( 'Text color for elements with an alternative accent background.', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-on-accent-alt',
			),
		),
		array(
			'id' => 'main_border_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Borders', 'total' ),
				'type' => 'color',
				'description' => esc_html__( 'Primary border color used for sidebar borders, entry dividers, tables, pagination, minimal buttons, tabs, toggles, etc.', 'total' ),
			),
			'inline_css' => array(
				'target' => ':root',
				'alter' => '--wpex-border-main',
			),
		),
	)
);