<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_background'] = array(
	'title' => esc_html__( 'Site Background', 'total' ),
	'panel' => 'wpex_general',
	'description' => esc_html__( 'Here you can alter the global site background. It is recommended that you first set the site layout to "Boxed" under Layout > General > Site Layout Style.', 'total' ),
	'settings' => array(
		array(
			'id' => 't_background_color',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Background Color', 'total' ),
				'type' => 'color',
			),
			'inline_css' => array(
				'target' => 'body,.boxed-main-layout,.footer-has-reveal #main',
				'alter' => 'background-color',
			),
		),
		array(
			'id' => 't_background_image',
			'sanitize_callback' => 'absint',
			'control' => array(
				'label' => esc_html__( 'Custom Background Image', 'total' ),
				'type' => 'media',
				'mime_type' => 'image',
			),
		),
		array(
			'id' => 't_background_style',
			'default' => 'stretched',
			'control' => array(
				'label' => esc_html__( 'Background Image Style', 'total' ),
				'type'  => 'select',
				'choices' => 'bg_style',
			),
		),
		// @todo move this to Site_Backgrounds class so the CSS is added in the same location.
		array(
			'id' => 't_background_position',
			'control' => array(
				'label' => esc_html__( 'Background Image Position', 'total' ),
				'type'  => 'text',
				'description' => esc_html__( 'This setting applies to only certain background image styles such as "No-Repeat" and allows you to position your background via the background-position CSS property.', 'total' ) . ' (<a href="https://developer.mozilla.org/en-US/docs/Web/CSS/background-position" target="_blank" rel="noopener noreferrer">' . esc_html__( 'see mozilla docs', 'total' ) . '</a>)',
			),
		),
		array(
			'id' => 't_background_pattern',
			'sanitize_callback' => 'esc_html',
			'control' => array(
				'label' => esc_html__( 'Background Pattern', 'total' ),
				'type'  => 'wpex_bg_patterns',
			),
		),
	),
);