<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_post_slider'] = array(
	'title' => esc_html__( 'Post Gallery Slider', 'total' ),
	'panel' => 'wpex_general',
	'settings' => array(
		array(
			'id' => 'post_slider_autoplay',
			'control' => array(
				'label' => esc_html__( 'Auto Play', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'post_slider_loop',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Loop', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'post_slider_thumbnails',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Thumbnails', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'post_slider_arrows',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Arrows', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'post_slider_arrows_on_hover',
			'control' => array(
				'label' => esc_html__( 'Arrows on Hover', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'post_slider_dots',
			'control' => array(
				'label' => esc_html__( 'Dots', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'post_slider_animation',
			'default' => 'slide',
			'control' => array(
				'label' => esc_html__( 'Animation', 'total' ),
				'type' => 'select',
				'choices' => array(
					'slide' => esc_html__( 'Slide', 'total' ),
					'fade' => esc_html__( 'Fade','total' ),
				),
			),
		),
		array(
			'id' => 'post_slider_animation_speed',
			'default' => '600',
			'control' => array(
				'label' => esc_html__( 'Custom Animation Speed', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter a value in milliseconds.', 'total' ),
			),
		),
	),
);