<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_breadcrumbs'] = array(
	'title' => esc_html__( 'Breadcrumbs', 'total' ),
	'panel' => 'wpex_general',
	'settings' => array(
		array(
			'id' => 'breadcrumbs',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Breadcrumbs', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'breadcrumbs_show_trail_end',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Ending Trail Title', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'breadcrumbs_show_terms',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Post Terms & Categories', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'breadcrumbs_first_cat_only',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Primary Post Term or Category Only', 'total' ),
				'type' => 'wpex_toggle',
			),
			'control_display' => array(
				'check' => 'breadcrumbs_show_terms',
				'value' => 'true',
			),
		),
		array(
			'id' => 'breadcrumbs_show_parents',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Show Parent Pages', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'breadcrumbs_visibility',
			'control' => array(
				'label' => esc_html__( 'Visibility', 'total' ),
				'type' => 'wpex-visibility-select',
			),
		),
		array(
			'id' => 'breadcrumbs_position',
			'transport' => 'refresh', // IMPORTANT !!!!
			'default' => 'page_header_aside',
			'control' => array(
				'label' => esc_html__( 'Location', 'total' ),
				'type'  => 'select',
				'choices' => array(
					'page_header_aside'   => esc_html__( 'Page Header Aside', 'total' ),
					'page_header_content' => esc_html__( 'Page Header Content', 'total' ),
					'page_header_after'   => esc_html__( 'After Page Header', 'total' ),
					'header_after'        => esc_html__( 'After Site Header', 'total' ),
					'custom'              => esc_html__( 'Custom Child Theme Location', 'total' ),
				),
				'active_callback' => 'wpex_cac_has_breadcrumbs',
			),
		),
		array(
			'id' => 'breadcrumbs_home_title',
			'control' => array(
				'label' => esc_html__( 'Custom Home Title', 'total' ),
				'type'  => 'text',
			),
		),
		array(
			'id' => 'breadcrumbs_title_trim',
			'control' => array(
				'label' => esc_html__( 'Title Trim Length', 'total' ),
				'type'  => 'text',
				'description' => esc_html__( 'Enter the max number of words to display for your breadcrumbs post title.', 'total' ),
			),
		),
		array(
			'id' => 'breadcrumbs_separator',
			'control' => array(
				'label' => esc_html__( 'Separator', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Enter an HTML entity, keyboard character or shortcode.', 'total' ),
			),
		),
		array(
			'id' => 'breadcrumbs_bg',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Background Color', 'total' ),
				'active_callback' => 'wpex_cac_has_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '.site-breadcrumbs',
				'alter' => 'Background-color',
			),
		),
		array(
			'id' => 'breadcrumbs_text_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Text Color', 'total' ),
				'active_callback' => 'wpex_cac_has_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '.site-breadcrumbs',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'breadcrumbs_seperator_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Separator Color', 'total' ),
				'active_callback' => 'wpex_cac_has_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '.site-breadcrumbs .sep',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'breadcrumbs_link_color',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color', 'total' ),
				'active_callback' => 'wpex_cac_has_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '.site-breadcrumbs a',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'breadcrumbs_link_color_hover',
			'transport' => 'postMessage',
			'control' => array(
				'type' => 'color',
				'label' => esc_html__( 'Link Color: Hover', 'total' ),
				'active_callback' => 'wpex_cac_has_breadcrumbs',
			),
			'inline_css' => array(
				'target' => '.site-breadcrumbs a:hover',
				'alter' => 'color',
			),
		),
		array(
			'id' => 'breadcrumbs_py',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Vertical Padding', 'total' ),
				'type'  => 'select',
				'choices' => 'padding',
			),
		),
		array(
			'id' => 'breadcrumbs_mt',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Top Margin', 'total' ),
				'type'  => 'select',
				'choices' => 'margin',
			),
		),
		array(
			'id' => 'breadcrumbs_mb',
			'transport' => 'partialRefresh',
			'control' => array(
				'label' => esc_html__( 'Bottom Margin', 'total' ),
				'type'  => 'select',
				'choices' => 'margin',
			),
		),
	),
);