<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_blog_single'] = array(
	'title' => esc_html__( 'Single Post', 'total' ),
	'panel' => 'wpex_blog',
	'settings' => array(
		array(
			'id' => 'post_singular_page_title',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_has_page_header',
			),
		),
		array(
			'id' => 'blog_single_layout',
			'control' => array(
				'label' => esc_html__( 'Page Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'blog_single_header',
			'default' => 'custom_text',
			'control' => array(
				'label' => esc_html__( 'Header Displays', 'total' ),
				'type' => 'select',
				'choices' => array(
					'custom_text' => esc_html__( 'Custom Text','total' ),
					'post_title' => esc_html__( 'Post Title','total' ),
					'first_category' => esc_html__( 'First Category','total' ),
				),
			),
			'control_display' => array(
				'check' => 'post_singular_page_title',
				'value' => 'true',
			),
		),
		array(
			'id' => 'blog_single_header_custom_text',
			'transport' => 'postMessage',
			'default' => esc_html__( 'Blog', 'total' ),
			'control' => array(
				'label' => esc_html__( 'Header Custom Text', 'total' ),
				'type' => 'text',
				'active_callback' => 'wpex_cac_blog_page_header_custom_text',
			),
		),

		// Post Layout
		array(
			'id' => 'blog_single_post_layout_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Post Layout', 'total' ),
			),
		),
		array(
			'id' => 'post_singular_template',
			'default' => '',
			'control' => array(
				'label' => esc_html__( 'Dynamic Template', 'total' ),
				'type' => 'wpex-dropdown-templates',
			),
		),
		array(
			'id' => 'blog_single_composer',
			'default' => 'featured_media,title,meta,post_series,the_content,post_tags,social_share,author_bio,related_posts,comments',
			'control' => array(
				'label' => esc_html__( 'Single Layout Elements', 'total' ),
				'type' => 'wpex_blocks',
				'choices' => 'TotalTheme\\Blog\\Single_Blocks::choices',
				'description' => esc_html__( 'Used when displaying the default (non-dynamic) post template.', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_singular_template',
			),
		),

		// Post Settings
		array(
			'id' => 'blog_single_post_settings_heading',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Post Settings', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_singular_template',
			),
		),
		array(
			'id' => 'blog_post_media_position_above',
			'control' => array(
				'label' => esc_html__( 'Large Featured Image', 'total' ),
				'type' => 'wpex_toggle',
				'description' => esc_html__( 'Enable to display your featured image above your post content and sidebar.', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_singular_template',
			),
		),
		array(
			'id' => 'blog_post_image_lightbox',
			'control' => array(
				'label' => esc_html__( 'Thumbnail Lightbox', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_singular_template',
			),
		),
		array(
			'id' => 'blog_thumbnail_caption',
			'control' => array(
				'label' => esc_html__( 'Thumbnail Caption', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_singular_template',
			),
		),
		array(
			'id' => 'blog_next_prev',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Next & Previous Links', 'total' ),
				'type' => 'wpex_toggle',
			),
		),
		array(
			'id' => 'blog_post_meta_sections',
			'default' => 'date,author,categories,comments',
			'control' => array(
				'label' => esc_html__( 'Meta Sections', 'total' ),
				'type' => 'wpex_blocks',
				'choices' => 'TotalTheme\\Meta::registered_blocks',
				'active_callback' => 'wpex_cac_has_blog_meta',
			),
		),
	),
);