<?php
defined( 'ABSPATH' ) || exit;

$this->sections['wpex_blog_archives'] = array(
	'title' => esc_html__( 'Archives & Entries', 'total' ),
	'panel' => 'wpex_blog',
	'settings' => array(
		array(
			'id' => 'blog_archive_has_page_header',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Page Header Title', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_has_page_header',
			),
		),
		array(
			'id' => 'blog_archives_layout',
			'control' => array(
				'label' => esc_html__( 'Page Layout', 'total' ),
				'type' => 'select',
				'choices' => 'post_layout',
			),
		),
		array(
			'id' => 'category_description_position',
			'control' => array(
				'label' => esc_html__( 'Category & Tag Description Position', 'total' ),
				'type' => 'select',
				'choices' => array(
					''			 => esc_html__( 'Default', 'total' ),
					'under_title' => esc_html__( 'Under Title', 'total' ),
					'above_loop' => esc_html__( 'Before Entries', 'total' ),
					'hidden' => esc_html__( 'Hidden', 'total' ),
				),
			),
		),
		array(
			'id' => 'blog_pagination_style',
			'control' => array(
				'label' => esc_html__( 'Pagination Style', 'total' ),
				'type' => 'select',
				'choices' => 'TotalTheme\\Pagination\\Core::choices',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'blog_archive_template_id',
			'control' => array(
				'label' => esc_html__( 'Dynamic Template', 'total' ),
				'type' => 'wpex-dropdown-templates',
				'description' => esc_html__( 'Select a template to override the default output for the main blog page, categories and tags.', 'total' ),
			),
		),
		// Entry Blocks
		array(
			'id' => 'blog_archives_heading_blocks',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Entry Layout', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'blog_entry_card_style',
			'control' => array(
				'label' => esc_html__( 'Card Style', 'total' ),
				'type' => 'wpex-card-select',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'blog_style',
			'control' => array(
				'label' => esc_html__( 'Entry Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'large-image-entry-style' => esc_html__( 'Large Image','total' ),
					'thumbnail-entry-style' => esc_html__( 'Left Thumbnail','total' ),
					'grid-entry-style' => esc_html__( 'Grid','total' ),
				),
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_left_thumbnail_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Left Thumbnail Width', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Default', 'total' ) .': 46%',
				'active_callback' => 'wpex_cac_blog_style_left_thumb',
			),
			'inline_css' => array(
				'target' => '.entries.left-thumbs .blog-entry .entry-media',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'blog_right_content_width',
			'transport' => 'postMessage',
			'control' => array(
				'label' => esc_html__( 'Right Content Width', 'total' ),
				'type' => 'text',
				'description' => esc_html__( 'Default', 'total' ) .': 50%',
				'active_callback' => 'wpex_cac_blog_style_left_thumb',
			),
			'inline_css' => array(
				'target' => '.entries.left-thumbs .blog-entry .entry-details',
				'alter' => 'width',
			),
		),
		array(
			'id' => 'blog_grid_style',
			'control' => array(
				'label' => esc_html__( 'Grid Style', 'total' ),
				'type' => 'select',
				'choices' => array(
					'' => esc_html__( 'Default', 'total' ),
					'fit-rows' => esc_html__( 'Fit Rows', 'total' ),
					'masonry' => esc_html__( 'Masonry', 'total' ),
				),
				'active_callback' => 'wpex_cac_grid_blog_style',
			),
		),
		array(
			'id' => 'blog_grid_columns',
			'control' => array(
				'label' => esc_html__( 'Grid Columns', 'total' ),
				'type' => 'select',
				'type' => 'wpex-columns',
				'choices' => array(
					''  => esc_html__( 'Default', 'total' ),
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'6' => '6',
				),
				'active_callback' => 'wpex_cac_grid_blog_style',
			),
		),
		array(
			'id' => 'blog_grid_gap',
			'control' => array(
				'label' => esc_html__( 'Gap', 'total' ),
				'type' => 'select',
				'choices' => 'column_gap',
				'active_callback' => 'wpex_cac_grid_blog_style',
			),
		),
		array(
			'id' => 'blog_entry_composer',
			'default' => 'featured_media,title,meta,excerpt_content,readmore',
			'control' => array(
				'label' => esc_html__( 'Entry Layout Elements', 'total' ),
				'type' => 'wpex_blocks',
				'choices' => 'TotalTheme\\Blog\\Entry_Blocks::choices',
				'description' => esc_html__( 'Used for the default non-card style layout.', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		// Other
		array(
			'id' => 'blog_archives_heading_entry_settings',
			'control' => array(
				'type' => 'wpex-heading',
				'label' => esc_html__( 'Entry Settings', 'total' ),
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_archive_grid_equal_heights',
			'control' => array(
				'label' => esc_html__( 'Equal Heights', 'total' ),
				'description' => esc_html__( 'If enabled it will set the content of each entry so they are the same height.', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_blog_supports_equal_heights',
			),
		),
		array(
			'id' => 'blog_entry_image_lightbox',
			'control' => array(
				'label' => esc_html__( 'Thumbnail Lightbox', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_entry_author_avatar',
			'control' => array(
				'label' => esc_html__( 'Author Avatar', 'total' ),
				'description' => esc_html__( 'If enabled it will display the post author avatar next to the entry title.', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_entry_video_output',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Featured Videos', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_entry_audio_output',
			'control' => array(
				'label' => esc_html__( 'Featured Audio', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_entry_gallery_output',
			'default' => true,
			'control' => array(
				'label' => esc_html__( 'Gallery Slider', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_exceprt',
			'default' => 'on',
			'control' => array(
				'label' => esc_html__( 'Auto Excerpts', 'total' ),
				'description' => esc_html__( 'If enabled the theme will automatically generate an excerpt for your entries based on the post content.', 'total' ),
				'type' => 'wpex_toggle',
				'active_callback' => 'wpex_cac_hasnt_card_or_dynamic_template',
			),
		),
		array(
			'id' => 'blog_entry_overlay',
			'control' => array(
				'label' => esc_html__( 'Image Overlay', 'total' ),
				'type' => 'select',
				'choices' => 'overlay',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'blog_entry_image_hover_animation',
			'control' => array(
				'label' => esc_html__( 'Image Hover Animation', 'total' ),
				'type' => 'select',
				'choices' => wpex_image_hovers(),
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'blog_entry_meta_sections',
			'default' => 'date,author,categories,comments',
			'control' => array(
				'label' => esc_html__( 'Meta Sections', 'total' ),
				'type' => 'wpex_blocks',
				'choices' => 'TotalTheme\\Meta::registered_blocks',
				'active_callback' => 'wpex_cac_has_blog_entry_meta',
			),
		),
		array(
			'id' => 'blog_excerpt_length',
			'default' => '40',
			'control' => array(
				'label' => esc_html__( 'Excerpt length', 'total' ),
				'type' => 'text',
				'active_callback' => 'wpex_cac_hasnt_archive_template',
			),
		),
		array(
			'id' => 'blog_entry_readmore_text',
			'default' => esc_html__( 'Read more', 'total' ),
			'control' => array(
				'label' => esc_html__( 'Read More Button Text', 'total' ),
				'type' => 'text',
				'active_callback' => 'wpex_cac_has_blog_entry_readmore',
			),
		),
	),
);