<?php
/**
 * Active callback functions for the customizer.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.6.1
 */

defined( 'ABSPATH' ) || exit;

/*-------------------------------------------------------------------------------*/
/* [ Core ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_container_layout_supports_max_width() {
	return ( 'full-width' === get_theme_mod( 'main_layout_style', 'full-width' ) && get_theme_mod( 'responsive', true ) ) ? true : false;
}

function wpex_cac_has_breadcrumbs() {
	return ( function_exists( 'yoast_breadcrumb' ) || get_theme_mod( 'breadcrumbs', true ) )  ? true : false;
}

// Used for typography options.
// @todo instead of using these checks perhaps we should hook into the typography settings and
// remove them completely so they aren't there but hidden - since you can only toggle on the footer
// builder via the wp-admin anyway.
function wpex_cac_has_footer_widgets() {
	if ( get_theme_mod( 'footer_builder_enable', true )
		&& function_exists( 'wpex_has_custom_footer' )
		&& wpex_has_custom_footer()
	) {
		return get_theme_mod( 'footer_builder_footer_widgets', false ) ? true : false;
	} else {
		return get_theme_mod( 'footer_widgets', true ) ? true : false;
	}
}

/*-------------------------------------------------------------------------------*/
/* [ Page Header ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_page_header() {
	return ( 'hidden' !== get_theme_mod( 'page_header_style' ) ) ? true : false;
}

function wpex_cac_supports_page_header_fetch_thumbnail() {
	if ( 'background-image' === get_theme_mod( 'page_header_style' )
		|| get_theme_mod( 'page_header_background_img' )
	) {
		return true;
	}
	return false;
}

/*-------------------------------------------------------------------------------*/
/* [ ToggleBar ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_togglebar() {
	return get_theme_mod( 'toggle_bar', true ) ? true : false; // used in Typography panel.
}

function wpex_cac_toggle_bar_has_toggle_btn() {
	if ( get_theme_mod( 'toggle_bar_enable_dismiss' )
		&& 'visible' === get_theme_mod( 'toggle_bar_default_state' )
	) {
		return false;
	}
	return true;
}

/*-------------------------------------------------------------------------------*/
/* [ Topbar ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_topbar() {
	return get_theme_mod( 'top_bar', true ) ? true : false;  // used in Typography panel.
}

/*-------------------------------------------------------------------------------*/
/* [ Header ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_header_supports_fixed_header() {
	return true;
}

function wpex_cac_has_fixed_header() {
	if ( 'disabled' === get_theme_mod( 'fixed_header_style' ) ) {
		return false; // fallback pre 5.6
	}
	return (bool) get_theme_mod( 'fixed_header' );
}

function wpex_cac_has_fixed_header_logo() {
	return ( wpex_cac_supports_fixed_header_logo() && get_theme_mod( 'fixed_header_logo' ) ) ? true : false;
}

function wpex_cac_has_fixed_header_shrink() {
	if ( ! wpex_cac_has_fixed_header() ) {
		return false;
	}
	return in_array( get_theme_mod( 'fixed_header_style' ), [ 'shrink', 'shrink_animated' ] );
}

function wpex_cac_logo_start_height() {
	return wpex_cac_has_fixed_header_shrink();
}

function wpex_cac_header_supports_fixed_menu() {
	$header_style = get_theme_mod( 'header_style' ) ?: 'one';
	if ( 'two' === $header_style
		|| 'three' === $header_style
		|| 'four' === $header_style
	) {
		return true;
	}
	return false;
}

function wpex_cac_show_sticky_header_mobile_notice() {
	if ( wpex_cac_header_supports_fixed_menu() || 'six' === get_theme_mod( 'header_style' ) ) {
		return true;
	}
	return false;
}

function wpex_cac_has_fixed_header_mobile_only() {
	if ( wpex_cac_header_supports_fixed_menu() && get_theme_mod( 'fixed_header_menu', true ) ) {
		return true;
	}
	return false;
}

/*-------------------------------------------------------------------------------*/
/* [ Logo ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_image_logo() {
	return (bool) get_theme_mod( 'custom_logo' );
}

function wpex_cac_supports_fixed_header_logo() {
	return ( wpex_cac_has_fixed_header() && wpex_cac_has_image_logo() );
}

function wpex_cac_hasnt_custom_logo() {
	return ! (bool) get_theme_mod( 'custom_logo' );
}

function wpex_cac_supports_logo_max_height_ratio() {
	if ( wpex_cac_has_image_logo() ) {
		$header_style = get_theme_mod( 'header_style' ) ?: 'one';
		if ( in_array( $header_style, array( 'seven', 'eight', 'nine', 'ten' ) ) ) {
			return true;
		}
	}
	return false;
}

/*-------------------------------------------------------------------------------*/
/* [ Menu ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_supports_menu_typo() {
	return ( 'dev' === get_theme_mod( 'header_style' ) ) ? false : true;
}

function wpex_cac_has_mobile_menu_icons() {
	$style = get_theme_mod( 'mobile_menu_toggle_style', 'icon_buttons' );
	if ( 'disabled' !== get_theme_mod( 'mobile_menu_style' )
		&& ( 'icon_buttons' === $style
			|| 'icon_buttons_under_logo' === $style
			|| 'centered_logo' === $style
			|| 'next_to_logo' === $style
		)
	) {
		return true;
	}
	return false;
}

function wpex_cac_mobile_menu_hamburger_has_label() {
	if ( ! get_theme_mod( 'mobile_menu_icon_label' ) || ! wpex_cac_has_mobile_menu_icons() ) {
		return false;
	}
	return true;
}

function wpex_cac_mobile_menu_hamburger_supports_active_state() {
	if ( ! wpex_cac_has_mobile_menu_icons() ) {
		return false;
	}
	return true;
}

function wpex_cac_mobile_menu_hamburger_supports_animation() {
	if ( ! wpex_cac_has_mobile_menu_icons() || ! get_theme_mod( 'mobile_menu_icon_toggle_state', true ) ) {
		return false;
	}
	return true;
}

function wpex_cac_has_menu_dropdown_top_border() {
	return (bool) get_theme_mod( 'menu_dropdown_top_border', false );
}

function wpex_cac_has_menu_pointer() {
	if ( get_theme_mod( 'menu_dropdown_style' ) ) {
		return false;
	} elseif ( 'one' !== get_theme_mod( 'header_style' ) ) {
		return false;
	} elseif ( get_theme_mod( 'menu_flush_dropdowns' ) ) {
		return false;
	}
	return true;
}

function wpex_cac_menu_supports_active_underline() {
	$header_style = get_theme_mod( 'header_style' );
	if ( 'six' === $header_style || 'dev' === $header_style ) {
		return false;
	}
	return true;
}

function wpex_cac_menu_has_active_underline() {
	if ( ! wpex_cac_menu_supports_active_underline() ) {
		return false;
	}
	return (bool) get_theme_mod( 'menu_active_underline', false );
}

function wpex_cac_menu_supports_pointer() {
	if ( ! in_array( get_theme_mod( 'header_style', 'one' ), array( 'one', 'five', 'seven', 'eight', 'nine', 'ten' ) )
		|| in_array( get_theme_mod( 'menu_dropdown_style' ), array( 'minimal-sq', 'minimal' ) )
		|| get_theme_mod( 'menu_flush_dropdowns', false )
		|| get_theme_mod( 'menu_dropdown_top_border', false )
	) {
		return false;
	}
	return true;
}

/*-------------------------------------------------------------------------------*/
/* [ Blog ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_blog_page_header_custom_text() {
	if ( get_theme_mod( 'post_singular_page_title', true )
		&& 'custom_text' === get_theme_mod( 'blog_single_header', 'custom_text' )
		&& wpex_cac_has_page_header()
	) {
		return true;
	}
	return false;
}

function wpex_cac_grid_blog_style( $control ) {
	if ( wpex_cac_has_card_or_template( $control ) ) {
		return false;
	}
	$style = get_theme_mod( 'blog_style' );
	return ( 'grid-entry-style' === $style || 'grid' === $style ) ? true : false;
}

function wpex_cac_blog_style_left_thumb( $control ) {
	if ( 'thumbnail-entry-style' === get_theme_mod( 'blog_style' )
		&& wpex_cac_hasnt_card_or_dynamic_template( $control )
	) {
		return true;
	}
	return false;
}

function wpex_cac_blog_supports_equal_heights( $control ) {
	if ( 'masonry' !== get_theme_mod( 'blog_grid_style' )
		&& wpex_cac_grid_blog_style( $control )
		&& wpex_cac_hasnt_card_or_dynamic_template( $control )
	) {
		return true;
	}
	return false;
}

function wpex_cac_has_blog_related( $control ) {
	if ( false !== strpos( get_theme_mod( 'blog_single_composer', 'related_posts' ), 'related_posts' )
		&& wpex_cac_hasnt_singular_template( $control )
	) {
		return true;
	}
}

function wpex_cac_has_blog_meta( $control ) {
	if ( false !== strpos( get_theme_mod( 'blog_single_composer', 'meta' ), 'meta' )
		&& wpex_cac_hasnt_singular_template( $control )
	) {
		return true;
	}
	return false;
}

function wpex_cac_has_blog_entry_readmore( $control ) {
	if ( false !== strpos( get_theme_mod( 'blog_entry_composer', 'readmore' ), 'readmore' )
		&& wpex_cac_hasnt_card_or_dynamic_template( $control )
	) {
		return true;
	}
	return false;
}

function wpex_cac_has_blog_entry_meta( $control ) {
	if ( false !== strpos( get_theme_mod( 'blog_entry_composer', 'meta' ), 'meta' )
		&& wpex_cac_hasnt_card_or_dynamic_template( $control )
	) {
		return true;
	}
	return false;
}

function wpex_cac_has_blog_single_media( $control ) {
	if ( false !== strpos( get_theme_mod( 'blog_single_composer', 'featured_media' ), 'featured_media' )
		&& wpex_cac_hasnt_singular_template( $control )
	) {
		return true;
	}
	return false;
}

function wpex_cac_has_blog_entry_media( $control ) {
	if ( false !== strpos( get_theme_mod( 'blog_entry_composer', 'featured_media' ), 'featured_media' )
		&& wpex_cac_hasnt_card_or_dynamic_template( $control )
	) {
		return true;
	}
	return false;
}

function wpex_cac_hasnt_blog_related_card() {
	return get_theme_mod( 'blog_related_entry_card_style' ) ? false : true;
}

/*-------------------------------------------------------------------------------*/
/* [ Portfolio ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_portfolio_related( $control ) {
	if ( false !== strpos( get_theme_mod( 'portfolio_post_composer', 'related' ), 'related' )
		&& wpex_cac_hasnt_singular_template( $control )
	) {
		return true;
	}
}

function wpex_cac_portfolio_supports_equal_heights( $control ) {
	if ( get_theme_mod( 'portfolio_entry_card_style' ) || wpex_cac_has_archive_template( $control ) ) {
		return false;
	}
	$style = get_theme_mod( 'portfolio_archive_grid_style' );
	if ( ! in_array( $style, array( 'masonry', 'no-margins' ), true ) ) {
		return true;
	}
}

function wpex_cac_hasnt_portfolio_card( $control ) {
	if ( get_theme_mod( 'portfolio_entry_card_style' ) || wpex_cac_has_archive_template( $control ) ) {
		return false;
	}
	return true;
}

function wpex_cac_hasnt_portfolio_related_card() {
	if ( get_theme_mod( 'portfolio_entry_card_style' ) || get_theme_mod( 'portfolio_related_entry_card_style' ) ) {
		return false;
	}
	return true;
}

/*-------------------------------------------------------------------------------*/
/* [ Staff ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_staff_related( $control ) {
	if ( false !== strpos( get_theme_mod( 'staff_post_composer', 'related' ), 'related' )
		&& wpex_cac_hasnt_singular_template( $control )
	) {
		return true;
	}
}

function wpex_cac_staff_supports_equal_heights( $control ) {
	if ( get_theme_mod( 'staff_entry_card_style' ) || wpex_cac_has_archive_template( $control ) ) {
		return false;
	}
	$style = get_theme_mod( 'staff_archive_grid_style' );
	if ( ! in_array( $style, array( 'masonry', 'no-margins' ), true ) ) {
		return true;
	}
}

function wpex_cac_hasnt_staff_related_card() {
	if ( get_theme_mod( 'staff_entry_card_style' ) || get_theme_mod( 'staff_related_entry_card_style' ) ) {
		return false;
	}
	return true;
}

function wpex_cac_hasnt_staff_card( $control ) {
	if ( get_theme_mod( 'staff_entry_card_style' ) || wpex_cac_has_archive_template( $control ) ) {
		return false;
	}
	return true;
}

/*-------------------------------------------------------------------------------*/
/* [ Dynamic templates ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_archive_template( $control ) {
	$id = $control->id ?? null;

	if ( ! $id || ! is_string( $id ) ) {
		return true;
	}

	$id = strtok( $id, '_' );

	if ( 'testimonial' === $id ) {
		$id = 'testimonials';
	}

	$template = (int) get_theme_mod( $id . '_archive_template_id' );

	if ( ! $template ) {
		return false;
	}

	$template_post = get_post( $template );

	if ( $template_post && is_a( $template_post, 'WP_Post' ) && 'trash' !== get_post_status( $template_post ) ) {
		return true;
	}

	return false;
}

function wpex_cac_hasnt_archive_template( $control ) {
	return ! wpex_cac_has_archive_template( $control );
}

function wpex_cac_has_singular_template( $control ) {
	$id = $control->id ?? null;

	if ( ! $id || ! is_string( $id ) ) {
		return true;
	}

	$id = strtok( $id, '_' );

	switch ( $id ) {
		case 'blog':
			$id = 'post';
			break;
		case 'testimonial':
			$id = 'testimonials';
			break;
	}

	$template = (int) get_theme_mod( $id . '_singular_template' );

	if ( ! $template ) {
		return false;
	}

	$template_post = get_post( $template );

	if ( $template_post && is_a( $template_post, 'WP_Post' ) && 'trash' !== get_post_status( $template_post ) ) {
		return true;
	}

	return false;
}

function wpex_cac_hasnt_singular_template( $control ) {
	return ! wpex_cac_has_singular_template( $control );
}

/*-------------------------------------------------------------------------------*/
/* [ Card templates ]
/*-------------------------------------------------------------------------------*/
function wpex_cac_has_card_style( $control ) {
	$id = $control->id ?? null;
	if ( ! $id || ! is_string( $id ) ) {
		return true;
	}
	$id = strtok( $id, '_' );
	if ( 'testimonial' === $id ) {
		$id = 'testimonials';
	}
	if ( ! in_array( $id, [ 'woo' ] ) && wpex_cac_has_archive_template( $control ) ) {
		return false;
	}
	return (bool) get_theme_mod( $id . '_entry_card_style', false );
}

function wpex_cac_hasnt_card_style( $control ) {
	return ! wpex_cac_has_card_style( $control );
}

function wpex_cac_has_card_or_template( $control ) {
	$id = $control->id ?? null;
	if ( ! $id || ! is_string( $id ) ) {
		return true;
	}
	$id = strtok( $id, '_' );
	if ( 'testimonial' === $id ) {
		$id = 'testimonials';
	}
	if ( get_theme_mod( $id . '_entry_card_style' ) || wpex_cac_has_archive_template( $control ) ) {
		return true;
	}
	return false;
}

function wpex_cac_hasnt_card_or_dynamic_template( $control ) {
	return ! wpex_cac_has_card_or_template( $control );
}