<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

/**
 * Customizer TRBL Control.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.4.5
 */
class Top_Right_Bottom_Left extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex_trbl';

	/**
	 * Check if the output should be in shorthand format.
	 */
	public $shorthand = false;

	/**
	 * Render Control Content.
	 */
	public function render_content() {
		$input_id    = '_customize-input-' . $this->id;
		$input_value = $this->value();
		$description = $this->get_description();

		$directions = array(
			'top' => array(
				'label' => '&uarr; ' . esc_html__( 'Top', 'total' ),
			//	'icon'  => 'dashicons dashicons-arrow-up-alt',
			),
			'right' => array(
				'label' => esc_html__( 'Right', 'total' ) . ' &rarr;',
			//	'icon'  => 'dashicons dashicons-arrow-right-alt',
			),
			'bottom' => array(
				'label' => '&darr; ' .esc_html__( 'Bottom', 'total' ),
			//	'icon'  => 'dashicons dashicons-arrow-down-alt',
			),
			'left' => array(
				'label' => '&larr; ' . esc_html__( 'Left', 'total' ),
			//	'icon'  => 'dashicons dashicons-arrow-left-alt',
			),
		);

		$parsed_value = (array) $this->parse_value( $input_value );

		$admin_color = get_user_option( 'admin_color' );
		$admin_color_class = $admin_color ? ' wpex-customize-trbl--' . esc_attr( $admin_color ) : '';

		?>

		<label class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>

		<?php if ( ! empty( $description ) ) : ?>
			<span id="_customize-description-<?php echo esc_attr( $this->id ); ?>" class="description customize-control-description"><?php echo esc_html( $description ); ?></span>
		<?php endif; ?>

		<ul class="wpex-customize-trbl<?php echo esc_attr( $admin_color_class ); ?>" data-wpex-shorthand="<?php echo json_encode( $this->shorthand ); ?>">

			<?php foreach ( $directions as $dir_key => $dir_val ) :

				$item_val = $parsed_value[$dir_key] ?? '';

				if ( 'px' === $this->get_unit( $item_val ) ) {
					$item_val = intval( $item_val );
				}
				?>

				<li class="wpex-customize-trbl__item">
					<div>
						<?php if ( ! empty( $dir_val['icon'] ) ) { ?>
							<span class="wpex-customize-trbl__icon" aria-hidden="true"><span class="<?php echo esc_attr( $dir_val['icon'] ); ?>"></span></span>
						<?php } ?>
						<input class="wpex-customize-trbl__input" name="<?php echo esc_attr( $this->id ); ?>_<?php echo esc_attr( $dir_key ); ?>" data-name="<?php echo esc_attr( $dir_key ); ?>" value="<?php echo esc_attr( $item_val ); ?>" type="text" placeholder="-">
					</div>
					<label class="wpex-customize-trbl__label" for="<?php echo esc_attr( $this->id ); ?>_<?php echo esc_attr( $dir_key ); ?>"><?php echo esc_attr( $dir_val['label'] ); ?></label>
				</li>

			<?php endforeach; ?>

		</ul>

		<input type="hidden" id="<?php echo esc_attr( $input_id ); ?>" value="<?php echo esc_attr( $input_value ); ?>" <?php $this->link(); ?>>

		<?php
	}

	/**
	 * Returns control description.
	 */
	protected function get_description() {
		$description = $this->description ?? '';
		if ( ! $description ) {
			if ( $this->shorthand ) {
				$description = esc_html__( 'This field uses a shorthand format so any empty field will be treated as 0px, however, if all fields are empty it will use the default theme styles.', 'total' );
			} else {
				$description = esc_html__( 'The theme will use a px unit if a unit is not provided.', 'total' );
			}
		}
		return $description;
	}

	/**
	 * Parses the value to convert into array of top/right/bottom/left.
	 */
	protected function parse_value( $val = '' ) {
		if ( ! $this->shorthand && false !== strpos( $val, ':' ) ) {
			return $this->parse_multi_prop_val( $val );
		}
		return $this->parse_single_prop_val( $val );
	}

	/**
	 * Parses a multi-property attribute value.
	 */
	protected function parse_multi_prop_val( $val = '' ) {
		$new_val = array(
			'top'    => '',
			'right'  => '',
			'bottom' => '',
			'left'   => '',
		);
		$params_pairs = explode( '|', $val );
		if ( ! empty( $params_pairs ) ) {
			foreach ( $params_pairs as $pair ) {
				$param = preg_split( '/\:/', $pair );
				if ( ! empty( $param[0] ) && isset( $param[1] ) ) {
					$new_val[$param[0]] = $param[1];
				}
			}
		}
		return $new_val;
	}

	/**
	 * Parses a single-property attribute.
	 */
	protected function parse_single_prop_val( $val = '' ) {
		$val = trim( $val );

		$new_val = array(
			'top'    => '',
			'right'  => '',
			'bottom' => '',
			'left'   => '',
		);

		if ( ! $val ) {
			return $new_val;
		}

		$array = explode( ' ', $val );

		if ( ! $array ) {
			return $new_val;
		}

		$count = count( $array );

		if ( 1 === $count ) {
			foreach( $new_val as $key => $val ) {
				$new_val[$key] = $array[0];
			}
		} else {
			if ( 2 === $count ) {
				$new_val['top']    = $array[0];
				$new_val['bottom'] = $array[0];
				$new_val['right']  = $array[1] ?? '';
				$new_val['left']   = $array[1] ?? '';
			} else {
				$new_val['top']    = $array[0];
				$new_val['right']  = $array[1] ?? '';
				$new_val['bottom'] = $array[2];
				$new_val['left']   = $array[3] ?? '';
			}
		}

		return $new_val;
	}

	/**
	 * Return css unit (text) from input.
	 */
	protected function get_unit( $input = '' ) {
		if ( $input && is_string( $input ) && ! is_numeric( $input ) ) {
			$non_numeric_string = preg_replace( '/[^0-9.]/', '', $input );
			$unit = str_replace( $non_numeric_string, '', $input );
			return trim( $unit );
		}
	}

}