<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

/**
 * Customizer Toggle Control.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.4
 */
class Toggle extends WP_Customize_Control {

	/**
	 * The control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'wpex_toggle';

	/**
	 * Render Control Content.
	 *
	 * @since 5.4
	 */
	public function render_content() {
		$input_id = '_customize-input-' . $this->id;
		$description_id = '_customize-description-' . $this->id;
		$checked = $this->value();
		?>

		<div class="wpex-customize-toggle-control<?php echo $checked ? ' wpex-customize-toggle-control--checked' : ''; ?>">
			<?php if ( ! empty( $this->label ) ) : ?>
				<label for="<?php echo esc_attr( $input_id ); ?>" class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>
			<?php endif; ?>
			<span class="wpex-customize-toggle-control__btn">
				<input id="<?php echo esc_attr( $input_id ); ?>" <?php $this->link(); ?> type="checkbox" <?php $this->input_attrs(); checked( $checked ); ?>>
				<span class="wpex-customize-toggle-control__track"></span>
				<span class="wpex-customize-toggle-control__thumb"></span>
			</span>
		</div>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<?php endif; ?>

		<?php

	}

}