<?php
namespace TotalTheme\Customizer\Controls;

use \WP_Customize_Control;

/**
 * Customizer Pixel Control
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.4
 */
class Pixel extends WP_Customize_Control {

	/**
	 * The control type.
	 *
	 * @access public
	 * @var string
	 */
	public $type = 'wpex_pixel';

	/**
	 * Render Control Content.
	 *
	 * @since 5.4
	 */
	public function render_content() {
		$input_id = '_customize-input-' . $this->id;
		$description_id = '_customize-description-' . $this->id;
		?>

		<?php if ( ! empty( $this->label ) ) : ?>
			<label for="<?php echo esc_attr( $input_id ); ?>" class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>
		<?php endif; ?>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description"><?php echo esc_html( $this->description ); ?></span>
		<?php endif; ?>

		<div class="wpex-customize-pixel-input-wrap">
			<input id="<?php echo esc_attr( $input_id ); ?>" value="<?php esc_attr( $this->value() ); ?>" <?php $this->link(); ?> type="text" <?php $this->input_attrs(); ?>>
			<div class="wpex-customize-pixel-input-wrap__unit">PX</div>
		</div>

		<?php

	}

}