<?php
namespace TotalTheme\Customizer\Controls;

use WP_Query;
use WP_Customize_Control;
use TotalTheme\Theme_Builder;

defined( 'ABSPATH' ) || exit;

/**
 * Customizer Templates Select Control.
 *
 * @package TotalTheme
 * @subpackage Customizer
 * @version 5.7.0
 */
class Dropdown_Templates extends WP_Customize_Control {

	/**
	 * The control type.
	 */
	public $type = 'wpex-dropdown-templates';

	/**
	 * Store template choices.
	 */
	static protected $template_choices;

	/**
	 * Render the content
	 */
	public function render_content() {
		if ( is_null( self::$template_choices ) ) {
			$types = Theme_Builder::get_template_post_types();

			$choices = [
				'' => '&#8211; ' . esc_html__( 'Select', 'total' ) . ' &#8211;',
			];

			$get_templates = new WP_Query( [
				'posts_per_page' => -1,
				'post_type'      => array_keys( $types ),
				'fields'         => 'ids',
			] );
			$multi_array = count( $types ) > 1;
			if ( $get_templates->posts ) {
				foreach ( $get_templates->posts as $template ) {
					$template = absint( $template );
					if ( $multi_array ) {
						$type = get_post_type( $template );
						if ( ! isset( $choices[$type] ) ) {
							$choices[$type] = [
								'label'   => $types[$type] ?? $type,
								'choices' => [],
							];
						}
						$choices[$type]['choices'][$template] = wp_strip_all_tags( get_the_title( $template ) );
					} else {
						$choices[$template] = wp_strip_all_tags( get_the_title( $template ) );
					}
				}
			}

			self::$template_choices = $choices;
		}

		$value          = $this->value();
		$input_id       = '_customize-input-' . $this->id;
		$description_id = '_customize-description-' . $this->id;
		$admin_color    = get_user_option( 'admin_color' );
		$describedby    = ( ! empty( $this->description ) ) ? ' aria-describedby="' . esc_attr( $description_id ) . '" ' : '';
		$admin_color    = $admin_color ? ' wpex-customizer-chosen-select--' . sanitize_html_class( $admin_color ) : '';

		?>

		<?php if ( ! empty( $this->label ) ) : ?>
			<label for="<?php echo esc_attr( $input_id ); ?>" class="customize-control-title"><?php echo esc_html( $this->label ); ?></label>
		<?php endif; ?>

		<?php if ( ! empty( $this->description ) ) : ?>
			<span id="<?php echo esc_attr( $description_id ); ?>" class="description customize-control-description"><?php echo wp_kses_post( $this->description ); ?></span>
		<?php endif; ?>

		<div class="wpex-customizer-chosen-select<?php echo esc_attr( $admin_color ); ?>">

			<select id="<?php echo esc_attr( $input_id ); ?>" <?php echo wp_strip_all_tags( $describedby ); ?> <?php $this->link(); ?>><?php

				if ( is_array( self::$template_choices ) ) {
					$option_selected = false;
					foreach ( self::$template_choices as $choice_k => $choice_v ) {
						if ( is_array( $choice_v ) && isset( $choice_v['choices'] ) ) {
							echo '<optgroup label="' . esc_attr( $choice_v['label'] ) . '">';
							foreach ( $choice_v['choices'] as $subchoice_k => $subchoice_v ) {
								if ( ! $option_selected && ( strval( $value ) === strval( $subchoice_k ) ) ) {
									$option_selected = true;
								}
								echo '<option value="' . esc_attr( $subchoice_k ) . '"' . selected( $value, $subchoice_k, false ) . '>' . esc_html( $subchoice_v ) . '</option>';
							}
							echo '</optgroup>';
						} else {
							if ( ! $option_selected && ( strval( $value ) === strval( $choice_k ) ) ) {
								$option_selected = true;
							}
							echo '<option value="' . esc_attr( $choice_k ) . '"' . selected( $value, $choice_k, false ) . '>' . esc_html( $choice_v ) . '</option>';
						}
					}

					if ( $value && ! $option_selected && get_post_status( $value ) ) {
						$type = get_post_type();
						$template_name = $type ? get_the_title( $value ) . ' (' . $type . ')' : esc_html__( 'Deleted Template', 'total' );

						echo '<option value="' . esc_attr( $value ) . '"' . selected( true, true, false ) . '>' . esc_html( $template_name ) . '</option>';
					}
				}

			?></select>

		</div>
	<?php }

}