<?php
namespace TotalTheme\Accessibility;

defined( 'ABSPATH' ) || exit;

/**
 * Adds custom CSS to the site to tweak the main accent colors.
 *
 * @package TotalTheme
 * @version 5.5
 */
final class Aria_Landmark {

	/**
	 * Current location to add aria landmark.
	 */
	protected static $location;

	/**
	 * Class constructor.
	 */
	public function __construct( $location = '' ) {
		self::$location = $location;
	}

	/**
	 * Render aria-landmark attribute.
	 */
	public function render() {
		if ( ! get_theme_mod( 'aria_landmarks_enable', false ) ) {
			return;
		}
		echo self::parse_location();
	}

	/**
	 * Returns landmark based on location
	 */
	protected static function parse_location() {
		$landmark = '';

		switch ( self::$location ) {
			case 'header':
				$landmark = 'role="banner"';
				break;
			case 'breadcrumbs':
				$landmark = 'role="navigation"';
				break;
			case 'site_navigation':
				$landmark = 'role="navigation"';
				break;
			case 'searchform':
				$landmark = 'role="search"';
				break;
			case 'main':
				$landmark = 'role="main"';
				break;
			case 'sidebar':
				$landmark = 'role="complementary"'; // @todo remove?
				break;
			case 'copyright':
				$landmark = 'role="contentinfo"';
				break;
			case 'footer_callout':
				$landmark = 'role="navigation"'; // @todo is this correct?
				break;
			case 'footer_bottom_menu':
				$landmark = 'role="navigation"';
				break;
			case 'scroll_top':
				$landmark = 'role="navigation"';
				break;
			case 'mobile_menu_alt':
				$landmark = 'role="navigation"';
				break;
		}

		$landmark = (string) apply_filters( 'wpex_get_aria_landmark', $landmark, self::$location );

		if ( ! empty( $landmark ) ) {
			return ' ' . trim( $landmark );
		}
	}

}