 <?php
/**
 * The template for displaying Comments.
 *
 * The area of the page that contains both current comments and the comment
 * form. The actual display of comments is handled by a callback to
 * wpex_comment() which is located at functions/comments-callback.php
 *
 * @package TotalTheme
 * @subpackage Templates
 * @version 5.44
 */

defined( 'ABSPATH' ) || exit;

if ( ! wpex_show_comments() ) {
	return;
}

wpex_hook_comments_before();

?>

<section id="comments" <?php wpex_comments_class(); ?>><?php

	$comments_number = number_format_i18n( get_comments_number() );
	if ( '1' == $comments_number ) {
		$comments_title = esc_html__( 'This Post Has One Comment', 'total' );
	} else {
		$comments_title = sprintf( esc_html__( 'This Post Has %s Comments', 'total' ), $comments_number );
	}
	$comments_title = apply_filters( 'wpex_comments_title', $comments_title );

	wpex_heading( array(
		'tag'           => get_theme_mod( 'comments_heading_tag' ) ?: 'h3',
		'content'		=> $comments_title,
		'classes'		=> array( 'comments-title' ) ,
		'apply_filters'	=> 'comments',
	) );
	?>

	<?php wpex_hook_comments_top(); ?>

	<?php if ( have_comments() ) : ?>

		<ol class="comment-list"><?php

			wp_list_comments( array(
				'style'       => 'ol',
				'avatar_size' => get_theme_mod( 'comment_avatar_size' ) ?: 50,
				'format'      => 'html5',
			) );

		?></ol>

		<?php the_comments_navigation(); ?>

		<?php if ( ! comments_open() && get_comments_number() ) : ?>

			<p class="no-comments wpex-text-md wpex-text-3 wpex-mt-30 wpex-text-center wpex-bold"><?php esc_html_e( 'Comments are closed.' , 'total' ); ?></p>

		<?php endif; ?>

	<?php endif; ?>

	<?php comment_form(); ?>

	<?php wpex_hook_comments_bottom();

?></section>

<?php wpex_hook_comments_after(); ?>