<?php
use TotalTheme\Pagination\Load_More;
use TotalTheme\Integration\WPBakery\Shortcode_Inline_Style as WPB_Style;

defined( 'ABSPATH' ) || exit;

if ( empty( $content ) ) {
	return;
}

$html = '';

if ( is_callable( [ 'WPBMap', 'addAllMappedShortcodes' ] ) ) {
	\WPBMap::addAllMappedShortcodes();
}

$content = wpex_parse_vc_content( $content );

set_query_var( 'wpex_card_object', $this );
	$content = do_shortcode( $content );
set_query_var( 'wpex_card_object', null );

if ( Load_More::is_doing_ajax() || ( function_exists( 'vcex_doing_loadmore' ) && vcex_doing_loadmore() ) ) {
	// Don't create extra CSS.
} else {
	$add_to_parsed = true;
	$html .= WPB_Style::instance()->get_style( [ $template_id, $this->post_id ], $add_to_parsed );
}

if ( $this->has_link() ) {
	// Replace all links with spans.
	$content = str_replace( '<a', '<span', $content );
	$content = str_replace( '</a>', '</span>', $content );

	// Open card link.
	$html .= $this->get_link_open( array(
		'class' => 'wpex-card-inner wpex-no-underline wpex-inherit-color',
		'attributes' => array(
			'aria-label' => get_the_title( $this->post_id ),
		),
	) );

	// Card content.
	$html .= $content;

	// Close card.
	$html .= $this->get_link_close();
} else {
	$html = $html .= '<div class="wpex-card-inner">' . $content . '</div>';
}

return $html;