document.addEventListener( 'click', function( event ) {
	const link = event.target.closest( '.wpex-social-share__link, .vcex-social-share__button' );

	if ( ! link ) {
		return;
	}

	const list    = link.closest( '.wpex-social-share, .vcex-social-share' );
	const classes = link.classList;
	const sUrl    = list.dataset.url;
	const target  = link.dataset.target;

	let specs     = list.dataset.specs || '';
	let sTitle    = list.dataset.title;
	let tUrl      = '';

	switch ( true ) {

		// Twitter
		case classes.contains( 'wpex-twitter' ):
			if ( list.dataset.twitterTitle ) {
				sTitle = list.dataset.twitterTitle;
			}
			tUrl = `https://twitter.com/intent/tweet?text=${sTitle}&url=${sUrl}`;
			if ( list.dataset.twitterHandle ) {
				tUrl += `&via=${list.dataset.twitterHandle}`;
			}
		break;

		// Facebook
		case classes.contains( 'wpex-facebook' ):
			tUrl = `https://www.facebook.com/sharer/sharer.php?u=${sUrl}`;
		break;

		// Pinterest
		case classes.contains( 'wpex-pinterest' ):
			tUrl = `https://www.pinterest.com/pin/create/button/?url=${sUrl}`;
			if ( list.dataset.image ) {
				tUrl += `&media=${list.dataset.image}`;
			}
			if ( list.dataset.summary ) {
				tUrl += `&description=${list.dataset.summary}`;
			}
		break;

		// Linkedin
		case classes.contains( 'wpex-linkedin' ):
			tUrl = `https://www.linkedin.com/shareArticle?mini=true&url=${sUrl}&title=${sTitle}`;
			if ( list.dataset.summary ) {
				tUrl += `&summary=${list.dataset.summary}`;
			}
			if ( list.dataset.source ) {
				tUrl += `&source=${list.dataset.source}`;
			}
		break;

		// Reddit
		case classes.contains( 'wpex-reddit' ):
			tUrl = `https://www.reddit.com/submit?url=${sUrl}&title=${sTitle}`;
		break;

		// Whatsapp
		case classes.contains( 'wpex-whatsapp' ):
			tUrl = `https://wa.me/?text=${sUrl}`;
		break;

		// Print
		case classes.contains( 'wpex-print' ):
			event.preventDefault();
			event.stopPropagation();
			return window.print();
		break;

		// Email
		case classes.contains( 'wpex-email' ):
			tUrl = `mailto:?subject=${list.dataset.emailSubject}&body=${list.dataset.emailBody}`;
			window.location.href = tUrl;
			event.preventDefault();
			event.stopPropagation();
			return;
		break;

		// Telegram
		case classes.contains( 'wpex-telegram' ):
			tUrl = `https://t.me/share/url?url=${sUrl}&text=${sTitle}`;
		break;

		// Other
		default:
			tUrl = link.getAttribute( 'href' );
			specs = '';
		break;

	}

	if ( ! tUrl ) {
		return;
	}

	window.open(
		tUrl,
		target,
		specs
	).focus();

	event.preventDefault();
	event.stopPropagation();

} );