/* jshint esversion: 6 */
if ( 'function' !== typeof window.wpexParallaxBackgrounds ) {
	window.wpexParallaxBackgrounds = ( context ) => {

		const supportsPassive = () => {
			var supportsPassive = false;
			try {
				var opts = Object.defineProperty({}, 'passive', {
				get: function() {
						supportsPassive = true;
					}
				} );
				window.addEventListener( 'testPassive', null, opts);
				window.removeEventListener( 'testPassive', null, opts);
			} catch (e) {}
			return supportsPassive;
		};

		const mobileCheck = () => {
			if ( /Android|webOS|iPhone|iPad|iPod|iPad Simulator|iPhone Simulator|iPod Simulator|BlackBerry|IEMobile|Opera Mini/i.test( navigator.userAgent ) ) {
				return true;
			}
		};

		const winScrollTop = () => {
			var scrollTop = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
			if ( scrollTop < 0 ) {
				scrollTop = 0; // return 0 if negative to prevent issues with elastic scrolling in Safari.
			}
			return scrollTop;
		};

		const getOffset = ( element ) => {
			var rect = element.getBoundingClientRect();
			return {
				top: rect.top + winScrollTop(),
				left: rect.left + winScrollTop(),
			};
		};

		const init = () => {
			document.querySelectorAll( '.wpex-parallax-bg' ).forEach( ( element ) => {

				// Disable on mobile.
				if ( element.classList.contains( 'not-mobile' ) && mobileCheck() ) {
					return;
				}

				// Parallax settings.
				const velocity = element.dataset.velocity;
				const direction = element.dataset.direction;
				const fixed = element.dataset.fixed;
				let startPosition = 0;
				let offset = null;

				// Get element dimensions and offsets.
				const elemHeight = element.getBoundingClientRect().height;
				const elemTop = getOffset( element ).top;
				const elemBottom = elemTop + element.getBoundingClientRect().height;

				// Get window dimensions and offsets.
				const winTop = winScrollTop();
				const winHeight = window.innerHeight;
				const viewTop =  winTop - 20;
				const viewBottom = winTop + winHeight + 20; // (adds 20px leeway)

				// Make sure element is in viewport.
				if ( elemTop >= viewBottom || elemBottom <= viewTop ) {
					return;
				}

				// If the element is below the fold, calculate the background image start position.
				if ( elemTop > winHeight ) {
					if ( 'none' !== direction ) {
						startPosition = ( elemTop - winHeight ) * Math.abs( velocity );
					}
				}

				// Calculate parallax position.
				const position = Math.ceil( startPosition + winTop * velocity );

				// Set background position.
				let xPos = '50%';
				let yPos = '50%';

				switch ( direction ) {
					case 'left':
						xPos = position + 'px';
						break;
					case 'right':
						xPos = 'calc(100% + ' + -position + 'px)';
						break;
					case 'down':
						if ( 'true' === fixed ) {
							yPos = 'calc(100% + ' + (-position) + 'px)';
						} else {
							const computedStyles = window.getComputedStyle( element );
							offset = - ( winHeight -
								elemTop -
								elemHeight -
								parseInt( computedStyles.getPropertyValue( 'padding-top' ) ) -
								parseInt( computedStyles.getPropertyValue( 'padding-bottom' ) ) );

							yPos = 'calc(100% + ' + ( offset - winTop - position ) + 'px)';
						}
						break;
					default:
						if ( 'true' === fixed ) {
							yPos = position + 'px';
						} else {
							yPos = ( elemTop - winTop + position ) + 'px';
						}
						break;
				}

				element.style.backgroundPosition = xPos + ' ' + yPos;

			} );
		};

		init(); // run immediately so that bg's look good on load.

		window.addEventListener( 'scroll', init, supportsPassive() ? { passive: true } : false );
	};
}

window.addEventListener( 'load', wpexParallaxBackgrounds );