/*jshint esversion: 6 */
window.vc_waypoints = function () {
	if ( 'function' !== typeof jQuery.fn.vcwaypoint ) {
		return;
	}

	// Standard VC animations.
	jQuery( '.wpb_animate_when_almost_visible:not(.wpb_start_animation)' ).each( function() {
		const $el = jQuery( this );
		if ( $el.closest( '.wpb-animate-in-sequence' ).length ) {
			return;
		}
		$el.vcwaypoint( function () {
			$el.addClass( 'wpb_start_animation animated' );
		}, { offset: wpex_vc_waypoints_params.offset } );
	} );

	// Sequential animations.

	/*const isVisible = ( el ) => {
		if ( ! el ) {
			return false;
		}
		return !!( el.offsetWidth || el.offsetHeight || el.getClientRects().length );
	};*/

	const sequentialAnimations = ( $grid ) => {
		const $items = $grid.find( '.wpb_animate_when_almost_visible:not(.wpb_start_animation)' );
		let delay    = $grid.attr( 'data-animation-delay' ) || wpex_vc_waypoints_params.delay;
		let timeouts = [];
		if ( ! $items.length ) {
			return;
		}

		jQuery.each( $items, function() {
			const $el = jQuery( this );

			const waypoint = new VcWaypoint( {
				element: $el,
				offset: wpex_vc_waypoints_params.offset,
				handler: function( direction ) {
					if ( $el.hasClass( 'animated' ) ) {
						return;
					}
					let $items = $grid.find( '.wpb_animate_when_almost_visible:not(.wpb_start_animation):visible' );
					const index = $items.index( $el );
					timeouts.push( setTimeout( function() {
						$el.addClass( 'wpb_start_animation animated' );
					}, index * delay ) );
				}
			} );

			document.addEventListener( 'vc_waypoints_sequence_destroy', event => {
				waypoint.destroy();
				for (let i = 0; i < timeouts.length; i++) {
					clearTimeout(timeouts[i]);
				}
			} );
		} );

	};

	jQuery( '.wpb-animate-in-sequence' ).each( function() {
		sequentialAnimations( jQuery( this ) );
	} );

};

jQuery( document ).ready( function ( $ ) {
	if ( 'undefined' === typeof window.vc_js ) {
		window.setTimeout( vc_waypoints, 500 );
	}
} );