/* jshint esversion: 6 */
( function( $ ) {

	'use strict';

	const afterShow = ( event, options ) => {
		if ( 'undefined' === typeof event ) {
			return;
		}

		const $this = $( event.target );
		let tab = $this.data( 'vc.accordion' );

		if ( ! tab ) {
			return;
		}

		tab = tab.getTarget();

		if ( ! tab ) {
			return;
		}

		if ( ! tab.length ) {
			return;
		}

		if ( 'function' === typeof jQuery.fn.sliderPro ) {
			tab.find( '.wpex-slider' ).each( function() {
				if ( $( this ).data( 'sliderPro' ) ) {
					$( this ).sliderPro( 'update' );
				}
			} );
		}

		if ( 'function' === typeof Isotope ) {
			tab.find( '.vcex-isotope-grid, .wpex-masonry-grid, .vcex-navbar-filter-grid' ).each( function() {
				var iso = Isotope.data( this );
				if ( iso ) {
					iso.layout();
				}
			} );
		}

	};

	$(document).on( 'afterShow.vc.accordion', afterShow );

} ) ( jQuery );