<?php
namespace TotalThemeCore\WPBakery\Params;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery Param => Time Zone.
 *
 * @package TotalThemeCore\WPBakery
 * @version 1.4.3
 */
final class Time_Zone {

	public static function output( $settings, $value ) {
		$html = '<select name="'
				. $settings['param_name']
				. '" class="wpb_vc_param_value wpb-input wpb-select vcex-chosen '
				. $settings['param_name']
				. ' ' . $settings['type'] .'">';

		$html .= '<option value="" '. selected( $value, '', false ) .'>' . esc_html__( 'Default', 'total' ) . '</option>';

		if ( function_exists( 'timezone_identifiers_list' ) ) {
			$zones = timezone_identifiers_list();
			foreach( $zones as $zone ) {
				$html .= '<option value="' . esc_attr( $zone )  . '" ' . selected( $value, $zone, false ) . '>' . esc_html( $zone ) . '</option>';
			}
		}

		$html .= '</select>';

		return $html;
	}

}