<?php
namespace TotalThemeCore\WPBakery\Params;

use TotalThemeCore\Vcex\Setting_Choices;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery Param => Select.
 *
 * @package TotalThemeCore
 * @version 1.5
 */
class Select {

	protected static $value_exists;

	public static function output( $settings, $value ) {
		$type = $settings['choices'] ?? $settings['param_name'] ?? [];
		$value = self::parse_value( $value, $type );
		$setting_choices = new Setting_Choices( $type, $settings );
		$choices = $setting_choices->get_choices();
		self::$value_exists = false; // must reset every time.

		if ( ! $choices ) {
			return;
		}

		$output = '<select name="'
			. esc_attr( $settings['param_name'] )
			. '" class="wpb_vc_param_value wpb-input wpb-select '
			. esc_attr( $settings['param_name'] )
			. ' ' . esc_attr( $settings['type'] ) .'">';

			$options_out = '';

			switch ( $type ) {
				case 'visibility':
					$options_out .= self::visibility_output( $value, $choices );
					break;
				default:
					foreach ( $choices as $key => $name ) {
						if ( $value && ! self::$value_exists && $key == $value ) { // use loose checks for numbers.
							self::$value_exists = true;
						}
						$options_out .= '<option value="' . esc_attr( $key )  . '" ' . selected( $value, $key, false ) . '>' . esc_attr( $name ) . '</option>';
					}
					break;
			}

			// if value isn't part of the choices we add it anyway to the select so it can be saved.
			if ( $value && ! self::$value_exists ) {
				$options_out = '<option value="' . esc_attr( $value )  . '" ' . selected( $value, $value, false ) . '>' . esc_attr( $value ) . '</option>' . $options_out;
			}

		$output .= $options_out;

		$output .= '</select>';

		return $output;
	}

	protected static function parse_value( $value, $type ) {
		switch ( $type ) {
			case 'visibility':
				$value = str_replace( '-portrait', '', $value );
				$value = str_replace( '-landscape', '', $value );
				break;
		}
		return $value;
	}

	protected static function visibility_output( $value, $choices ) {
		$output = '';
		$groups = [
			'main' => [
				'label' => esc_attr__( 'Main', 'total-theme-core' ),
				'options' => []
			],
			'mobile_menu' => [
				'label' => esc_attr__( 'Mobile Menu', 'total-theme-core' ),
				'options' => []
			],
			'responsive' => [
				'label' => esc_attr__( 'Responsive', 'total-theme-core' ),
				'options' => []
			],
			'toggles' => [
				'label' => esc_attr__( 'Toggles', 'total-theme-core' ),
				'options' => []
			],
			'custom' => [
				'label' => esc_attr__( 'Custom', 'total-theme-core' ),
				'options' => []
			],
		];
		foreach ( $choices as $key => $name ) {
			if ( $value && ! self::$value_exists && $key === $value ) {
				self::$value_exists = true;
			}
			if ( in_array( $key, [ '', 'hidden' ] ) ) {
				$groups['main']['options'][$key] = $name;
			} elseif ( in_array( $key, [ 'hidden-toggle-element', 'hidden-toggle-element-persist', 'visible-toggle-element', 'visible-toggle-element-persist' ] ) ) {
				$groups['toggles']['options'][$key] = $name;
			} elseif ( in_array( $key, [ 'show-at-mm-breakpoint', 'hide-at-mm-breakpoint' ] ) ) {
				$groups['mobile_menu']['options'][$key] = $name;
			} elseif ( in_array( $key, [ 'visible-desktop-large', 'hidden-desktop-large', 'visible-desktop', 'hidden-desktop', 'visible-tablet', 'hidden-tablet', 'visible-phone', 'hidden-phone' ] ) ) {
				$groups['responsive']['options'][$key] = $name;
			} else {
				$groups['custom']['options'][$key] = $name;
			}
		}
		foreach ( $groups as $group_k => $group ) {
			if ( empty( $group['options'] ) ) {
				continue;
			}
			$output .= '<optgroup label="' . $group['label'] . '">';
			foreach ( $group['options'] as $key => $name ) {
				$output .= '<option value="' . esc_attr( $key )  . '" ' . selected( $value, $key, false ) . '>' . esc_attr( $name ) . '</option>';
			}
			$output .= '</optgroup>';
		}
		return $output;
	}

}