<?php
namespace TotalThemeCore\WPBakery\Params;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery Param => Menu.
 *
 * @package TotalThemeCore
 * @version 1.6.1
 */
final class Menu {

	public static function output( $settings, $value ) {
		$html = '<select name="'
				. esc_attr( $settings['param_name'] )
				. '" class="wpb_vc_param_value wpb-input wpb-select '
				. esc_attr( $settings['param_name'] )
				. ' ' . esc_attr( $settings['type'] ) . '">';

		$html .= '<option value="" ' . selected( $value, '', false ) . '>' . esc_html( 'Select', 'total-theme-core' ) . '</option>';

			$html .= '<optgroup label="' . esc_attr( 'WP Nav Menus', 'total-theme-core' ) . '">';

			$menus_array = [];
			$menus = get_terms( 'nav_menu', [
				'hide_empty' => true
			] );
			if ( is_array( $menus ) ) {
				foreach ( $menus as $menu ) {
					$html .= '<option value="' . esc_attr( $menu->term_id ) . '" ' . selected( $value, $menu->term_id, false ) . '>' . esc_attr( $menu->name ) . '</option>';
				}
			}

			$html .= '</optgroup>';

			$html .= '<optgroup label="' . esc_attr( 'Dynamic Menus', 'total-theme-core' ) . '">';
				$html .= '<option value="dynamic_terms" ' . selected( $value, 'dynamic_terms', false ) . '>' . esc_html( 'Taxonomy Terms', 'total-theme-core' ) . '</option>';
				$html .= '<option value="current_tax_terms" ' . selected( $value, 'current_tax_terms', false ) . '>' . esc_html( 'Current Taxonomy Child Terms', 'total-theme-core' ) . '</option>';
			$html .= '</optgroup>';

		$html .= '</select>';

		return $html;
	}

}