<?php
namespace TotalThemeCore\WPBakery\Params;

defined( 'ABSPATH' ) || exit;

/**
 * WPBakery Param > Font Size.
 *
 * @package TotalThemeCore
 * @subpackage WPBakery
 * @version 1.4.3
 */
final class Font_Size {

	public static function output( $settings, $value ) {
		if ( $value && strpos( $value, ':' ) === false ) {
			$ogvalue = $value;
			$value = 'd:'. $value;
		}

		$medias = array(
			'd'  => array(
				'label' => esc_html__( 'Desktop', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-desktop',
			),
			'tl' => array(
				'label' => esc_html__( 'Tablet Landscape', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-tablet',
			),
			'tp' => array(
				'label' => esc_html__( 'Tablet Portrait', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-tablet',
			),
			'pl' => array(
				'label' => esc_html__( 'Phone Landscape', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-smartphone',
			),
			'pp' => array(
				'label' => esc_html__( 'Phone Portrait', 'total-theme-core' ),
				'icon'  => 'dashicons dashicons-smartphone',
			),
		);

		$defaults = array();

		foreach ( $medias as $key => $val ) {
			$defaults[$key] = '';
		}

		$has_responsive = false;

		$field_values = array();
		$params_pairs = ( $value && is_string( $value ) ) ? explode( '|', $value ) : '';
		if ( ! empty( $params_pairs ) ) {
			if ( count( $params_pairs ) > 1 ) {
				$has_responsive = true;
			}
			foreach ( $params_pairs as $pair ) {
				$param = preg_split( '/\:/', $pair );
				if ( ! empty( $param[0] ) && isset( $param[1] ) ) {
					$field_values[$param[0]] = rawurldecode( $param[1] );
				}
			}
		}

		$fields_class = 'vcex-param-font-size';

		if ( ! $has_responsive ) {
			$fields_class .= ' vcex-param-font-size--single';
		}

		$html = '<div class="' . $fields_class . '">';

			$html .= '<div class="vcex-param-font-size__list">';
				foreach ( $medias as $key => $val ) {
					$field_name = $settings['param_name'] . '[' . $key . ']';
					$icon_class = $val['icon'];
					$hidden_class = '';

					$html .= '<div class="vcex-param-font-size__item">';

						if ( 'pl' === $key || 'tl' === $key ) {
							$icon_class .= ' dashicons--flip';
						}

						$html .= '<div class="vcex-param-font-size__icon"><span class="' . esc_attr( $icon_class ) . '"></span></div>';

						$html .= '<label for="' . esc_attr( $field_name ) .'" class="screen-reader-text">' . $medias[$key]['label'] . '</label>';

						$html .= '<input id="' . esc_attr( $field_name ) .'" data-vcex-device="' . esc_attr( $key ) . '" value="' . esc_attr( $field_values[$key] ?? '' ) . '" type="text">';

					$html .= '</div>';

				}
			$html .= '</div>';

			$button_pressed = $has_responsive ? 'true' : 'false';
			$html .= '<button title="' . esc_html__( 'Enter responsive inputs.', 'total-theme-core' ) . '" class="vcex-param-font-size__toggle" aria-pressed="' . esc_attr( $button_pressed ) . '"><svg width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" role="img" aria-hidden="true" focusable="false" fill="currentColor"><path d="M14.5 13.8c-1.1 0-2.1.7-2.4 1.8H4V17h8.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20v-1.5h-3.1c-.3-1-1.3-1.7-2.4-1.7zM11.9 7c-.3-1-1.3-1.8-2.4-1.8S7.4 6 7.1 7H4v1.5h3.1c.3 1 1.3 1.8 2.4 1.8s2.1-.7 2.4-1.8H20V7h-8.1z"></path></svg></button>';

			if ( ! empty( $ogvalue ) ) {
				$value = $ogvalue;
			}

			$html .= '<input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value  ' . esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . esc_attr( $value ) . '">';

		$html .= '</div>';

		if ( empty( $settings['description'] ) ) {
			$html .= '<div class="vc_description vc_clearfix">' . esc_html__( 'Allowed units:', 'total-theme-core' ) . ' px, em, rem, vw, vmin, vmax.<br>' . esc_html__( 'Allowed CSS functions:', 'total-theme-core' ) . ' calc(), clamp().<br>' . esc_html( 'Allowed variables:', 'total-theme-core' ) . ' <a href="#">xs</a>, <a href="#">sm</a>, <a href="#">md</a>, <a href="#">lg</a>, <a href="#">xl</a>, <a href="#">2xl</a>, <a href="#">3xl</a>, <a href="#">4xl</a>, <a href="#">5xl</a>, <a href="#">6xl</a>, <a href="#">7xl</a></div>';
		}

		return $html;
	}

}