<?php
namespace TotalThemeCore\WPBakery\Map;
use \VCEX_Post_Type_Carousel_Shortcode;

defined( 'ABSPATH' ) || exit;

/**
 * Class registers the vcex_post_type_carousel shortcode with the WPBakery page builder.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
final class Vcex_Post_Type_Carousel {

	/**
	 * Our single class instance.
	 */
	private static $instance;

	/**
	 * Create or retrieve the class instance.
	 */
	public static function instance() {
		if ( is_null( static::$instance ) ) {
			static::$instance = new self();
			static::$instance->init_hooks();
		}

		return static::$instance;
	}

	/**
	 * Hook into actions and filters.
	 */
	public function init_hooks() {
		add_action( 'vc_after_mapping', array( $this, 'vc_after_mapping' ) );
	}

	/**
	 * Run functions on vc_after_mapping hook.
	 */
	public function vc_after_mapping() {
		vc_lean_map( 'vcex_post_type_carousel', array( $this, 'map' ) );

		$vc_action = vc_request_param( 'action' );

		if ( 'vc_get_autocomplete_suggestion' === $vc_action || 'vc_edit_form' === $vc_action ) {

			// Get autocomplete suggestion
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_tax_query_taxonomy_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_filter_taxonomy_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_tax_query_terms_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_categories_taxonomy_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::callback'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_author_in_callback',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Users::callback'
			);

			// Render autocomplete suggestions
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_filter_taxonomy_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::render'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_tax_query_taxonomy_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::render'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_categories_taxonomy_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomies::render'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_tax_query_terms_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Taxonomy_Terms::render'
			);
			add_filter(
				'vc_autocomplete_vcex_post_type_carousel_author_in_render',
				'TotalThemeCore\\WPBakery\\Autocomplete\\Users::render'
			);

		}
	}

	/**
	 * Map shortcode via vc_lean_map.
	 */
	public function map() {
		return array(
			'name'        => esc_html__( 'Post Types Carousel', 'total-theme-core' ),
			'description' => esc_html__( 'Posts carousel', 'total-theme-core' ),
			'base'        => 'vcex_post_type_carousel',
			'category'    => vcex_shortcodes_branding(),
			'icon'        => 'vcex_element-icon vcex_element-icon--carousel',
			'params'      => VCEX_Post_Type_Carousel_Shortcode::get_params(),
		);
	}

}