<?php
namespace TotalThemeCore\Widgets;

use TotalThemeCore\WidgetBuilder as Widget_Builder;

defined( 'ABSPATH' ) || exit;

/**
 * Modern Menu widget.
 *
 * @package TotalThemeCore
 * @subpackage Widgets
 * @version 1.4.6
 */
class Widget_Modern_Menu extends Widget_Builder {
	private $args;

	/**
	 * Register widget with WordPress.
	 */
	public function __construct() {
		$this->args = array(
			'id_base' => 'wpex_modern_menu',
			'name'    => $this->branding() . esc_html__( 'Modern Sidebar Menu', 'total-theme-core' ),
			'options' => array(
				'customize_selective_refresh' => true,
			),
			'fields'  => array(
				array(
					'id'    => 'title',
					'label' => esc_html__( 'Title', 'total-theme-core' ),
					'type'  => 'text',
				),
				array(
					'id'      => 'nav_menu',
					'label'   => esc_html__( 'Select Menu', 'total-theme-core' ),
					'type'    => 'select',
					'choices' => 'menus',
				),
			),
		);

		$this->create_widget( $this->args );
	}

	/**
	 * Front-end display of widget.
	 */
	public function widget( $args, $instance ) {
		extract( $this->parse_instance( $instance ) );

		echo wp_kses_post( $args['before_widget'] );

		$this->widget_title( $args, $instance );

		if ( $nav_menu ) {

			$menu_args = [
				'menu_class'  => 'modern-menu-widget',
				'fallback_cb' => '',
				'menu'        => $nav_menu,
			];

			if ( function_exists( 'wpex_get_theme_icon_html' ) ) {

				$link_before = '<span class="modern-menu-widget__link-text">';
				$link_after = '</span>';

				$link_arrow = (string) apply_filters( 'wpex_modern_menu_widget_link_icon', 'material/arrow-back-ios' );

				if ( $link_arrow ) {
					$layout = function_exists( 'wpex_content_area_layout' ) ? wpex_content_area_layout() : 'right-sidebar';

					if ( 'left-sidebar' === $layout ) {
						$link_after = $link_after . '<span class="modern-menu-widget__link-icon wpex-flex wpex-ml-auto wpex-rotate-180">' . wpex_get_theme_icon_html( $link_arrow ) . '</span>';
					} else {
						$link_before = '<span class="modern-menu-widget__link-icon wpex-flex">' . wpex_get_theme_icon_html( $link_arrow ) . '</span>' . $link_before;
					}
				}

				$menu_args['link_before'] = $link_before;
				$menu_args['link_after'] = $link_after;

			}

			wp_nav_menu( $menu_args );
		}

		echo wp_kses_post( $args['after_widget'] );
	}

}
register_widget( 'TotalThemeCore\\Widgets\\Widget_Modern_Menu' );