<?php
namespace TotalThemeCore\Widgets;

use TotalThemeCore\WidgetBuilder as Widget_Builder;

defined( 'ABSPATH' ) || exit;

/**
 * Advertisement widget.
 *
 * @package TotalThemeCore
 * @version 1.4.9
 */
class Widget_Advertisement extends Widget_Builder {
	private $args;

	/**
	 * Register widget with WordPress.
	 *
	 * @since 1.0
	 */
	public function __construct() {
		$this->args = array(
			'id_base' => 'wpex_advertisement',
			'name'    => $this->branding() . esc_html__( 'Advertisement', 'total-theme-core' ),
			'options' => array(
				'customize_selective_refresh' => true,
			),
			'fields'  => array(
				array(
					'id'    => 'title',
					'label' => esc_html__( 'Title', 'total-theme-core' ),
					'type'  => 'text',
				),
				array(
					'id'      => 'columns',
					'label'   => esc_html__( 'Columns', 'total-theme-core' ),
					'type'    => 'select',
					'choices' => array(
						'1' => '1',
						'2' => '2',
					),
				),
				array(
					'id'      => 'breakpoint',
					'label'   => esc_html__( 'Stacking Breakpoint', 'total-theme-core' ),
					'type'    => 'select',
					'default' => 'sm',
					'choices' => array(
						'sm'   => esc_html__( 'sm - 640px', 'total' ),
						'md'   => esc_html__( 'md - 768px', 'total' ),
						'lg'   => esc_html__( 'lg - 1024px', 'total' ),
						'xl'   => esc_html__( 'xl - 1280px', 'total' ),
						'none' => esc_html__( 'None (no stacking)', 'total' ),
					),
				),
				array(
					'id'      => 'columns_gap',
					'label'   => esc_html__( 'Column Gap', 'total-theme-core' ),
					'type'    => 'select',
					'choices' => 'grid_gaps',
				),
				array(
					'id'    => 'stretch_img',
					'label' => esc_html__( 'Stretch Images?', 'total-theme-core' ),
					'type'  => 'checkbox',
					'description' => esc_html__( 'Force a 100% width on the advertisement images so they fill up the parent container.', 'total-theme-core' ),
				),
				array(
					'id'    => 'nofollow',
					'label' => esc_html__( 'Add "nofollow" to links?', 'total-theme-core' ),
					'type'  => 'checkbox',
				),
				array(
					'id'    => 'target_blank',
					'label' => esc_html__( 'Open links in a new tab?', 'total-theme-core' ),
					'type'  => 'checkbox',
				),
				array(
					'id'    => 'ads',
					'label' => esc_html__( 'Ads', 'total-theme-core' ),
					'type'  => 'repeater',
					'fields' => array(
						array(
							'id' => 'url',
							'label' => esc_html__( 'Link URL', 'total-theme-core' ),
							'type'  => 'text',
						),
						array(
							'id' => 'image',
							'label' => esc_html__( 'Image', 'total-theme-core' ),
							'type'  => 'media_upload',
						),
					),
				),
			),
		);

		$this->create_widget( $this->args );
	}

	/**
	 * Front-end display of widget.
	 */
	public function widget( $args, $instance ) {
		extract( $this->parse_instance( $instance ) );

		// Before widget hook
		echo wp_kses_post( $args[ 'before_widget' ] );

		// Display widget title
		$this->widget_title( $args, $instance );

		// Define widget output
		$output = '';

		if ( $ads && is_array( $ads ) ) {

			$row_class = array(
				'wpex-ads-widget',
				'wpex-grid',
			);

			if ( 'none' === $breakpoint || ! function_exists( 'wpex_grid_columns_class' ) ) {
				$row_class[] = 'wpex-grid-cols-' . sanitize_html_class( $columns );
			} else {
				$row_class[] = 'wpex-' . sanitize_html_class( $breakpoint ) . '-grid-cols-' . sanitize_html_class( $columns );
			}

			$columns_gap = $columns_gap ?: 10;

			if ( 'none' !== $columns_gap ) {
				$row_class[] = 'wpex-gap-' . sanitize_html_class( $columns_gap );
			}

			$output .= '<div class="' . esc_attr( implode( ' ', $row_class ) ) . '">';

			foreach ( $ads as $ad ) :

				if ( empty( $ad[ 'url' ] ) && empty( $ad[ 'image' ] ) ) {
					continue;
				}

				$output .= '<div class="wpex-ads-widget__item">';

				$image = $ad[ 'image' ];
				$alt = '';

				if ( is_numeric( $image ) ) {
					$alt   = get_post_meta( $image, '_wp_attachment_image_alt', TRUE );
					$image = wp_get_attachment_url( $image );
				}

				if ( $image ) {

					// Add link tag
					$output .= '<a href="' . esc_url( $ad[ 'url' ] ) . '"';

						if ( wp_validate_boolean( $target_blank ) ) {
							$output .= ' target="_blank"';
						}

						if ( wp_validate_boolean( $nofollow ) ) {
							$output .= ' rel="nofollow"';
						}

					$output .= '>';

					// Display Image
					$image_class = 'wpex-align-bottom';

					if ( wp_validate_boolean( $stretch_img ) ) {
						$image_class .= ' stretch-image';
					}

					$output .= '<img src="' . esc_url( $image ) . '" class="' . esc_attr( $image_class ) . '"';

						if ( $alt ) {
							$output .= ' alt="' . esc_attr( $alt ) . '"';
						}

					$output .= '>';

					$output .= '</a>';

				}

				$output .= '</div>';

			endforeach;

			$output .= '</div>';

		}

		// @codingStandardsIgnoreLine
		echo $output;

		// After widget hook
		echo wp_kses_post( $args[ 'after_widget' ] );
	}

}
register_widget( 'TotalThemeCore\\Widgets\\Widget_Advertisement' );